Although the Impact heuristic seems to make a better exploration of the search tree on some easy instances (like s2-f25, g14-f27, s11, s11-f12), it is clearly slower compared to conflict-driven heuristics. This is mainly because the process of impact initialization is time consuming. On hard instances, the Impact heuristic has worse performance and in some cases it cannot solve the problem within the time limit on all instances. In general we observed that impact based heuristics cannot handle efficiently problems which include variables with relatively large domains. Some RLFA problems, for example, have 680 variables with up to 44 values in their domains.

Node Impact and its variation, "Impact RSC", are strongly related, and this similarity is depicted in the results. As mentioned in Section 3, Node Impact computes the accurate impacts and the "RSC" heuristic computes the reduction in the search space, after the application of Restricted Singleton Consistency. Since node impact computation also uses Restricted Singleton Consistency (it subsumes it), these heuristics differ only in the measurement function that assigns impacts to variables. Hence, when they are used to break ties on the Impact heuristic, they usually make similar decisions.

When "RSC" is used as a tie breaker for conflict-driven heuristics, results show that it does not offer significant changes in the performance. So we have excluded it from the experiments that follow in the next sections, except for the dom/wdeg + RSC combination.

Concerning "random probing", although experiments in [21] show that it has often better performance when compared to simple *dom/wdeg*, our results show that this is not the case when *dom/wdeg* is combined with a geometric restart strategy. Even on hard instances, where the computation cost of random probes is small compared to the total search cost, results show that *dom/wdeg* and its variations are dominant. Moreover, the combination of "random probing" with any other conflict-driven variation heuristic ("alldel" or "fully assigned") does not result in significant changes in the performance. Thus, for the next experiments we have kept only the "random probing" and *dom/wdeg* combination.

Finally, among the three conflict-driven variations, *"alldel"* seems to display slightly better performance on this set of instances.

## 4.3. Structured And Patterned Instances

This set of experiments contains instances from academic problems (langford), some real world instances from the "driver" problem and 6 patterned instances from the graph coloring problem. The constraint graphs of the latter are randomly generated but the structure of the constraints follows a specific pattern as they are all binary inequalities. Since some of the variations presented in the previous paragraph (Table 2) were shown to be less interesting, we have omitted their results from the next tables.

Results in Table 3 show that the behavior of the selected heuristics is close to the behavior that we observed in RLFA problems. Conflict-driven variations are again dominant here. The *dom/wdeg* heuristic has in most cases the best performance, followed by "alldel" and "fully assigned". Impact based heuristics