the arity of the constraints is large and the cost of constraint propagation is high. As a result, adding random probing forced the solver to time out on many instances.

## 4.6. Boolean Instances

This set of experiments contains instances involving only Boolean variables and non-binary constraints. We have selected a representative subset from Dimacs problems. To be precise, we have included a subset of the "jnhSat" collection which includes the hardest instances from this collection, 4 randomly selected instances from the "aim" set, where all problems are relatively easy to solve, and the first instance from the "pret" and "dubois" sets, which include very hard instances. All the selected instances have constraint arity of 3, except for the "jnhSat" instances which have maximum arity of 14.

Results from these experiments can be found in Table 6. The behavior of the evaluated heuristics in this data set is slightly different from the behavior that we observed in previous problems. Although conflict-driven heuristics again display the best overall performance, impact based heuristics are in some cases faster.

The main bottleneck that impact based heuristics have, is the time consuming initialization process. On Boolean instances, where the variables have binary domains, the cost for the initialization of impacts is small. And this can significantly increase the performance of these heuristics.

Among the conflict-driven heuristics, the "alldel" heuristic is always better than its competitors. We recall here that in this heuristic constraint weights are increased by the size of the domain reduction. Hence, on binary instances constraint weights can be increased at minimum by one and at maximum by two (in each DWO).

The same good performance of the "alldel" heuristic was also observed in 30 additional instances from the Dimacs problem class ("aim" instances) not shown here. These extended experiments showed that this way of incrementing weights seems to work better on Boolean problems where the deletion of a single value is of greater importance compared to problems with large domains, i.e. it is more likely to lead to a DWO.

## 4.7. The Effect Of Restarts On The Results

In all the experiments reported in the previous sections we followed a geometric restart policy. This policy were introduced in [40] and it has been shown to be very effective. However, different restart policies can be applied within the search algorithm, or we can even discard restarts in favor of a single search run. In order to check how the selected restart policy affects the performance of the evaluated variable ordering heuristics, we ran some additional experiments.

Apart from the geometric restart policy which we used on the previous experiments, we also tried an arithmetic restart policy. In this policy the initial number of allowed backtracks for the first run has been set to 10 and at each new run the number of allowed backtracks increases also by 10. We have also tested the behavior of the heuristics without the use of any restarts.