Selected results are depicted in Table 7. Unsurprisingly, results show that the arithmetic restart policy is clearly inefficient. On instances that can be solved within a small number of restarts (like *scen11, ehi-85-297-0, rb30-15-1* and *ash958GPIA-4* ), the differences between the arithmetic and the geometric restart policies are small. But, when some problem (like *scen11-f7, aim-200-1-6,*
langford-4-10 and *cc-12-12-2* ) requires a large number of restarts to be solved, the geometric restart policy clearly outperforms the arithmetic one. Importantly for the purposes of this paper, this behavior is independent of the selected variable ordering heuristic.

Comparing search without restart to the geometric restart policy, we can see that the latter is more efficient some instances. But in general restarts are necessary to solve very hard problems. Importantly, the relative behavior of the conflict-driven heuristics compared to impact based heuristics is not significantly affected by the presence or absence of restarts. That is, the conflict-driven heuristics are always faster than the impact based ones, with or without restarts.

Some small differences in the relative performance of the conflict-driven heuristics can be noticed when no restarts are used, but they generally have similar cpu times. *Random probing* seems to work better with no restarts, in accordance with the results and conjectures in [39], but this small improvement is not enough for it to become more efficient than the *dom/wdeg*, "*alldel*" and "*fully* assigned" heuristics.

## 4.8. Using Random Value Ordering

As noted at the beginning of Section 4, all the experiments were ran with a lexicographic value ordering. In order to check if this affects the performance of the evaluated variable ordering heuristics, we have ran some additional experiments. In these experiments we study the performance of the heuristics when random value ordering is used.

Selected results are depicted in Table 8 where we show cpu times for both random and lexicographic value ordering. Concerning the random value ordering, all the results presented here are averaged values for 50 runs. Looking at the results and comparing the performance of the heuristics under the different value orderings, we can see some differences in cpu time. However, the relative behavior of the conflict-driven heuristics compared to impact based heuristics is not significantly affected by the use of lexicographic or random value ordering.

## 4.9. A General Summary Of The Results

In order to get a summarized view of the evaluated heuristics, we present six figures. In these figures we have included cpu time and number of visited nodes for the three major conflict-driven variants (*dom/wdeg*, "*alldell*" and "*fully assigned*") and we have compared them graphically to the Impact heuristic (which has the best performance among the impact based heuristics).

Results are collected in Figure 1. The left plots in these figures correspond to cpu times and the right plots to visited nodes. Each point in these plots, shows the cpu time (or nodes visited) for one instance from all the presented