dom/wdeg. One might argue that a way to overcome this is to continue propagation after the first DWO is detected, try to identify all possible DWOs and increase the weights of all constraints involved in failures. The problem with this approach is threefold: First, it may increase the cost of constraint propagation significantly, second it requires modifications in the way all solvers implement constraint propagation (i.e. stopping after a failure is detected), and third, experiments we have run showed that the possibility of more than one DWO
occurring is typically very low. As we will discuss in Section 5.5, some variants of *dom/wdeg* are less amenable to different revision orderings, i.e. their performance do not depend on the ordering as much, without having to implement this potentially complex approach.

In the following we first review three standard implementations of revision lists for AC, i.e. the arc-oriented, variable-oriented, and constraint-oriented variants. Then, we summarize the major revision ordering heuristics that have been proposed so far in the literature, before describing the new efficient revision ordering heuristics we propose.

## 5.1. Ac Variants

The numerous AC algorithms that have been proposed can be classified into coarse grained and *fine grained*. Typically, coarse grained algorithms like AC-3
[25] and its extensions (e.g. AC2001/3.1 [6] and AC-3d [16]) apply successive revisions of arcs, variables, or constraints. On the other hand, fine grained algorithms like AC-4 [28] and AC-7 [4] use various data structures to apply successive revisions of variable-value-constraint triplets. Here we are concerned with coarse grained algorithms, and specifically AC-3. There are two reasons for this. First, although AC-3 does not have an optimal worst-case time complexity, as the fine grained algorithms do, it is competitive and often better in practice and has the additional advantage of being easy to implement. Second, many constraint solvers that can handle constraints of any arity follow the philosophy of coarse grained AC algorithms in their implementation of constraint propagation. That is, they apply successive revisions of variables or constraints. Hence, the revision ordering heuristics we describe below can be easily incorporated into most of the existing solvers.

As mentioned, the AC-3 algorithm can be implemented using a variety of propagation schemes. We recall here the three variants, following the presentation of [7], which respectively correspond to algorithms with an arc-oriented, variable-oriented or constraint-oriented propagation scheme.

The first one (arc-oriented propagation) is the most commonly presented and used because of its simple and natural structure. Algorithm 1 depicts the main procedure. As explained, an arc is a pair (cij , xj ) which corresponds to a directed constraint. Hence, for each binary constraint cij involving variables xi and xj there are two arcs, (cij , xj ) and (cij , xi). Initially, the algorithm inserts all arcs in the revision list Q. Then, each arc (cij , xj ) is removed from the list and revised in turn. If any value in D(xj ) is removed when revising (cij , xj ), all arcs pointing to xj (i.e. having xi as second element in the pair), except (cij , xi), will be inserted in Q (if not already there) to be revised. Algorithm 2