efficiency was limited to the reduction of list operations and constraint checks.

We demonstrate that when a conflict-driven variable ordering heuristic like dom/wdeg is used, then there are cases where the order in the elements of the list are revised can affect the variable selection. Inspired by this, a third contribution of this paper is to propose new, conflict-driven, heuristics for ordering the revision list. We show that these heuristics can not only reduce the numbers of constraints checks and list operations, but also cut down the size of the explored search tree. Results from various benchmarks demonstrate that some of the proposed heuristics can boost the performance of the *dom/wdeg* heuristic up to 5 times. Interestingly, we also show that some of the new variants of *dom/wdeg* that we propose are much less amenable to the revision ordering than *dom/wdeg*.

The main contributions of this paper can be summarized as follows:

- We give experimental results from a detailed comparison of modern variable ordering heuristics in a wide range of academic, random and real world problems. These experiments demonstrate that *dom/wdeg* and its variants can be considered the most efficient and robust among the heuristics compared.
- Based on our observation concerning the interaction between conflictdriven variable ordering heuristics and revision ordering heuristics, we extend the use of failures discovered during search to devise new and efficient revision ordering heuristics. These heuristics can increase the efficiency of the solver by not only reducing list operation but also by cutting down the size of the explored search tree.

- We show that certain variants of *dom/wdeg* are less amenable to changes in the revision ordering than *dom/wdeg* and therefore can be more robust.

The rest of the paper is organized as follows. Section 2 gives the necessary background material. In Section 3 we give an overview of existing variable ordering heuristics. In Section 4 we present and discuss the experimental results from a wide variety of real world, academic and random problems. In Section 5 after a short summary on the existing revision ordering heuristics for constraint propagation, we propose a set of new revision ordering heuristics based on constraint weights. We then give experimental results comparing these heuristics with existing ones. Section 5 concludes with a discussion and some experimental results on the dependency between conflict-driven variable ordering heuristics and revision orderings. Finally, conclusions are presented in Section 6.

## 2. Background

A *Constraint Satisfaction Problem* (CSP) is a tuple (*X, D, C* ), where X
is a set containing n variables {x1, x2*, ..., x*n}; D is a set of domains {D(x1), D(x2)*,...,* D(xn)} for those variables, with each D(xi) consisting of the possible