x1. Finally, assume that at some point during search only the variables x1 and x2 have remained in the AC revision list Q, but with different orderings for R1 and R2. That is, QR1
:{x1,x2}, QR2
:{x2,x1}. Following all these assumptions
(which can exist commonly in any real world CSP), lets now trace the behavior of both R1 and R2 during problem solving. Considering the QR1 list, the revision of x1 is fruitful and adds x3 in the list (due to hypothesis a). Now the revision list changes to QR1
:{x2,x3}. The sequential revision of x2 and x3 leads to the DWO of x4 (due to hypotheses b and d). Considering the QR2 list, the revision of x2 is fruitful and adds x4 in the list (due to hypothesis b). Now the revision list changes to QR2
:{x4,x1}. The sequential revision of x4 and x1 leads to the DWO of x3. (due to hypotheses c and e).

From the above example it is clear that although only one DWO is identified in the revision list, both x1 and x2 can be responsible for this. In R1 where x1 is the DWO variable, we can say that x2 is also a "potential" DWO variable i.e. it would be a DWO variable, if the R2 revision ordering was used. Although the *dom/wdeg* heuristic ignores all the "potential" DWO variables, the other two DVO heuristics,"*alldel*" and "*fully assigned*", take into account their contribution. The former heuristic increases the weights for every constraint that causes a value deletion, and thus succeeds to increase the weights of the constraints related to the "potential" DWO variables. The latter heuristic increases the weights of constraints that participate in fruitful revisions (only for revision lists that lead to a DWO), and thus is able to frequently identify "potential" DWO variables.

To experimentally verify the strong dependance of *dom/wdeg* heuristic on the revision ordering and the ability of the "*alldel*" and "*fully assigned*" heuristics to be less dependent, we have computed the variance in the number of node visits for the three conflict-driven heuristics on some selected instances.

The variance is a measure of how spread out a distribution of a variable's values is. A variable's spread is the degree to which the values of the variable differ from each other. If all values of the variable were about equal, the variable would have very little spread. In other words, it is a measure of variability. In our case the measured variable x is the number of visited nodes for the conflictdriven heuristics. For each conflict-driven heuristic the x variable can take N=3 values. That is, the number of visited nodes when any one of the 3 main revision ordering heuristics (queue, dom, v *dom/wdeg*) is used.

The variance is calculated by taking the arithmetic mean of the squared differences between each value and the mean value, using the following equation:
V ARIANCE =
P(x − x¯)
2 N(4)
where x is the number of node visits when a specific revision ordering heuristic is used and ¯x is the mean number of visited nodes of the N=3 main revision ordering heuristics (queue, dom, v *dom/wdeg*).

The smaller the variance of a conflict-driven heuristic, the less the dependance from the selected revision ordering heuristic. Results from these ex-

$$\sum(x\ )$$
$\hat{\mathbf{r}}$