iments presented is known as MGAC (maintaining generalized arc consistency)
or MAC in the case of binary problems [33, 5]. This algorithm can be implemented using either a *d-way* or a *2-way* branching scheme. The former works as follows. Initially, the whole problem should be made GAC before starting search. After the first variable x with domain D(x) = {a1, a2*, ..., a*d} is selected, d recursive calls are made. In the first call value a1 is assigned to x and the problem is made GAC, i.e. all values which are not GAC given the assignment of a1 to x are removed. If this call fails (i.e. no solution is found), the value a1 is removed from the domain of x and the problem is made again GAC. Then a second recursive call under the assignment of a2 to x is made, and so on. The problem has no solution if all d calls fail. In *2-way* branching, after a variable x and a value ai ∈ D(x) are selected, two recursive calls are made. In the first call aiis assigned to x, or in other words the constraint x=aiis added to the problem, and GAC is applied. In the second call the constraint x 6= aiis added to the problem and GAC is applied. The problem has no solution if neither recursive call finds a solution. The main difference of these branching schemes is that in *2-way* branching, after a failed choice of a variable assignment (x,ai) the algorithm can choose a new assignment for any variable (not only x). In *d-way* branching the algorithm has to choose the next available value for variable x.

## 3. Overview Of Variable Ordering Heuristics

The order in which variables are assigned by a backtracking search algorithm has been understood for a long time to be of primary importance. The first category of heuristics used for ordering variables was based on the initial structure of the network. These are called static or fixed variable ordering heuristics (SVOs)
as they simply replace the lexicographic ordering by something more appropriate to the structure of the network before starting search. Examples of such heuristics are *min width* which chooses an ordering that minimizes the width of the constraint network [17], *min bandwidth* which minimizes the bandwidth of the constraint graph [41], and max degree (deg), where variables are ordered according to the initial size of their neighborhood [15].

A second category of heuristics includes dynamic variable ordering heuristics
(DVOs) which take into account information about the current state of the problem at each point in the search. The first well known dynamic heuristic, introduced by Haralick and Elliott, was dom [22]. This heuristic chooses the variable with the smallest remaining domain. The dynamic variation of deg, called *ddeg* selects the variable with largest dynamic degree. That is, for binary CSPs, the variable that is constrained with the largest number of unassigned variables. By combining dom and deg (or *ddeg*), the heuristics called *dom/deg* and *dom/ddeg* [5, 36] were derived. These heuristics select the variable that minimizes the ratio of current domain size to static degree (dynamic degree) and can significantly improve the search performance.

When using variable ordering heuristics, it is a common phenomenon that ties can occur. A tie is a situation where a number of variables are considered equivalent by a heuristic. Especially at the beginning of search, where it is more