it does not require any tuning.

Experiments with instantiations of the two generic heuristics confirm that search with adaptive branching outperforms search with a fixed branching scheme on a wide range of problems. Interestingly, in many cases the gains offered by full 2-way branching are also obtained by the adaptive branching methods with only very few decisions following the VOH
when it suggests to move away from the current variable at successful right branches.

The rest of the paper is organized as follows. Section 2 gives necessary background. In Section 3 we compare the three branching schemes detailed above on a variety of CSP instances. Section 4 presents the proposed heuristics for adaptive branching. In Section 5 we demonstrate the efficacy of the heuristics through an experimental study. Finally, in Section 6 we conclude.

## 2 Background

A Constraint Satisfaction Problem (CSP) is a tuple (**X, D,**
C ), where X is a set containing n variables {x1, x2**, ..., x**n}; D is a set of domains {D(x1), D(x2),..., D(xn)} **for those**
variables, with each D(xi**) consisting of the possible values**
which xi may take; and C **is a set of constraints between** variables in subsets of X. Each constraint ci ∈ C **expresses a** relation defining which variable assignment combinations are allowed for the variables in the scope of the constraint.The degree of a variable x **is the number of constraints involving**
x, and the dynamic degree **of (an unassigned variable)** x is the number of constraints involving x **and at least one other** unassigned variable.

Complete search algorithms for CSPs are typically based on backtracking depth-first search where branching decisions (e.g. variable assignments) are interleaved with constraint propagation. Search is guided by variable ordering heuristics
(VOHs) and value ordering heuristics. The classic VOH smallest domain (dom**) selects the variable with minimum domain**
size [4]. Other, more sophisticated, heuristics include **dom/deg**
and dom/ddeg **[1], which select the variable with minimum ratio of domain size over degree (resp. dynamic degree).**
One of the most efficient general purpose VOHs that have been proposed is dom/wdeg **[2]. This heuristic assigns a weight**
to each constraint, initially set to one. Each time a constraint causes a conflict, i.e. a domain wipeout (DWO), its weight is incremented by one. Each variable is associated with a weighted degree**, which is the sum of the weights over all constraints involving the variable and at least another unassigned**
variable. The dom/wdeg **heuristic chooses the variable with** minimum ratio of current domain size to weighted degree.

This heuristic is among the most efficient, if not the most efficient, general-purpose heuristics for CSPs. Grimes and Wallace proposed alternative conflict-driven heuristics that consider value deletions as the basic conflicts associated with constraint weights [3]. The alldel **heuristic increments the weight**
of a constraint each time it causes one or more value deletions from a domain. The efficacy of all the proposed conflictdirected heuristics is due to their ability to learn though conflicts (either DWOs or value deletions) encountered during search. As a result they can guide search towards hard parts of the problem earlier.

A CSP search algorithm is usually implemented using either a d-way or a 2-way branching scheme2**. The former works as**
follows. After a variable x with domain D(x) = {a1, a2**, ..., a**d}
is selected, d **branches are created, each one corresponding to a** value assignment of x. In the first branch, value a1 **is assigned**
to x **and constraint propagation is triggered. If this branch** fails, a1 is removed from D(x**). Then the assignment of** a2 to x is made (second branch), and so on. If all d **branches**
fail then the algorithm backtracks. An example of a search tree explored with d**-way branching is shown in Figure 1a. In**
2-way branching, after a variable x **and a value** ai ∈ D(x)
are selected, two branches are created. In the left branch ai is assigned to x, or in other words the constraint x=ai **is added** to the problem and is propagated. In the right branch the constraint x 6= ai **is added to the problem and is propagated.**
If both branches fail then the algorithm backtracks. Figure 1b shows a search tree explored with 2-way branching.

There are two differences between these branching schemes:
- **In 2-way branching, if the branch assigning a value** ai to a variable x fails then the removal of ai from D(x) is immediately propagated. Instead, d**-way branching tries the**
next available value aj of D(x**). Note that the propagation** of aj subsumes the propagation of ai**'s removal.**
- **In 2-way branching, after a failed branch corresponding to**
an assignment x=ai, and assuming the removal of ai **from** D(x**) is then propagated successfully, the algorithm can**
choose to branch on any variable (not necessarily x), according to the VOH (e.g. Figure 1b). In d**-way branching**
the algorithm has to choose the next available value for variable x after x=ai **fails.**

![0_image_0.png](0_image_0.png)

schemes.
In between these two schemes is the version of 2-way branching used in [9] where the algorithm is forced to assign x **with its next value after the successful propagation of**
ai's removal from D(x). In the following we call this **restricted** 2-way branching**. Figure 1c shows a search tree explored with** restricted 2-way branching.

## 3 Comparison Of Branching Schemes

The search algorithm used in all the experiments presented hereafter is the commonly used maintaining (generalized) arc consistency (MAC) algorithm [7, 1]. We have experimented 2 Domain splitting is also used, but it is not considered here.