# A Homogeneous Reaction Rule Language For Complex Event Processing

Adrian Paschke RuleML Inc., Canada adrian.paschke AT
gmx.de Alexander Kozlenkov Betfair Ltd., London alex.kozlenkov AT
betfair.com

# Harold Boley National Research Council, Canada Harold.Boley At Nrc.Gc.Ca

## Abstract

Event-driven automation of reactive functionalities for complex event processing is an urgent need in today's distributed service-oriented architectures and Web-based event-driven environments. An important problem to be addressed is how to correctly and efficiently capture and process the event-based behavioral, reactive logic embodied in reaction rules, and combining this with other conditional decision logic embodied, e.g., in derivation rules. This paper elaborates a homogeneous integration approach that combines derivation rules, reaction rules and other rule types such as integrity constraints into the general framework of logic programming, the industrial-strength version of declarative programming. We describe syntax and semantics of the language, implement a distributed web-based middleware using enterprise service technologies and illustrate its adequacy in terms of expressiveness, efficiency and scalability through examples extracted from industrial use cases.

The developed reaction rule language provides expressive features such as modular ID-based updates with support for external imports and self-updates of the intensional and extensional knowledge bases, transactions including integrity testing and roll-backs of update transition paths. It also supports distributed complex event processing, event messaging and event querying via efficient and scalable enterprise middleware technologies and event/action reasoning based on an event/action algebra implemented by an interval-based event calculus variant as a logic inference formalism.

## 1. Introduction

Event-driven applications based on reactive rules which trigger actions as a response to the detection of events have been extensively studied during the 1990s. Stemming from the early days of programming language where system events were used for interrupt and exception handling, active event-driven rules have received great attention in different areas such as active databases which started in the late 1980s, real-time applications and system and network management tools which emerged in the early 1990s as well as publish-subscribe systems which appeared in the late 1990s. Recently, there has been an increased interest in industry and academia in event-driven mechanisms and high-level Event-Driven Architectures (EDA). (Pro-)active real-time or justin-time reactions to events are a key factor in upcoming agile and flexible IT infrastructures, distributed loosely coupled service ori- Permission to copy without fee all or part of this material is granted provided that the copies are not made or distributed for direct commercial advantage, the VLDB copyright notice and the title of the publication and its date appear, and notice is given that copying is by permission of the Very Large Data Base Endowment. To copy otherwise, or to republish, to post on servers or to redistribute to lists, requires a fee and/or special permission from the publisher, ACM.

VLDB '07, September 23-28, 2007, Vienna, Austria.

Copyright 2007 VLDB Endowment, ACM 978-1-59593-649-3/07/09.

ented environments or new business models such as On-Demand or Utility computing. Industry trends such as Real-Time Enterprise (RTE), Business Activity Management (BAM) or Business Performance Management (BPM) and closely related areas such as Service Level Management (SLM) with monitoring and enforcing Service Level Agreements (SLAs) [13, 15] are business drivers for this renewed interest. Another strong demand for event processing functionalities comes from the web community, in particular in the area of Semantic Web and Rule Markup Languages
(e.g. RuleML [1]).

Different rule-based approaches to reactive event processing have been developed, which have for the most part proceeded separately and have led to different views and terminologies:
- Active databases in their attempt to combine techniques from expert systems and databases to support automatic triggering of global rules in response to events and to monitor state changes in database systems have intensively explored and developed the ECA paradigm and event algebras to compute complex events and trigger reactions according to global ECA rules.

- Event notification and messaging systems facilitate the communication of events in a distributed environment (push/pull)
or monitor external systems which notify subscribed clients upon detected events. Typically, the interest here is in a context-dependent event sequence which follows e.g. a communication protocol or coordination workflow, rather than in single event occurrences which trigger immediate reactions.

- In event/action logics, which have their origins in the area of knowledge representation (KR) and logic programming
(LP), the focus is on the formalization of action/event axioms and on the inferences that can be made from the happened or planned events/actions.

For a classification of the event/action/state processing space and a survey on different reaction rules approaches see [12].

In this paper we present an approach based on logic programming which combines and exploit the advantages of the different logic and rule-based approaches and implement a homogeneous reaction rule language and an efficient scalable middleware which supports, e.g., complex event- and action processing, event communication/messaging, formalization of reaction rules in combination with other rule types such as derivation rules and transactional ID-based knowledge updates which dynamically change the intensional and extensional knowledge base (KB). We further show how this approach fits into RuleML, a standardization initiative for describing different rule types on the (Semantic) Web.

In section 2 we introduce global reactions rules which follow the ECA paradigm. In section 3 we develop an interval-based event algebra which supports logic-based complex event processing in three phases: event definition, event selection (detection/querying) and event consumption (via rule-based consumption policies). In section 4 we introduce transactional module-based update actions into our reaction rule language which are the basis for highlydistributed open and modular web-based ordered logic programs
(OLPs). Section 5 describes Reaction RuleML which serves as a