

![0_image_0.png](0_image_0.png)

exchange inbound and outbound event messages through registered routers to the components' endpoint addresses. The three processing modes of Mule are [10]:
- Asynchronously: many events can be processed by the same component at a time in various threads. When the Mule server is running asynchronously instances of a component run in various threads all accepting incoming events, though the event will only be processed by one instance of the component.

- Synchronously: when a Component receives an event in this mode the whole request is executed in a single thread
- Request-Response: this allows for a Component to make a specific request for an event and wait for a specified time to get a response back The object broker follows the Staged Event Driven Architecture (SEDA) pattern [19]. The basic approach of SEDA is to decomposes a complex, event-driven application into a set of stages connected by queues. This design decouples event and thread scheduling from application logic and avoids the high overhead associated with thread-based concurrency models. That is, SEDA
supports massive concurrency demands on Web-based services and provides a highly scalable approach for asynchronous communication. Figure 3 shows a simplified breakdown of the Mule integration.

Several inference services which at their core run a rule engine are installed as Mule components which listen at configured endpoints, e.g., JMS message endpoints, HTTP ports, SOAP server/client addresses or JDBC database interfaces. Reaction RuleML is used as a common platform independent rule interchange format between the agents (and possible other rule execution / inference services). Translator services are used to translate inbound and outbound messages from PIM Reaction RuleML into the PSM rule engines execution syntaxes and vice versa. XSLTs and ANTLR based translator services are provided as Web forms, HTTP services and SOAP Web services on the Reaction RuleML
Web page [18].

The large variety of transport protocols provided by Mule can be used to transport the messages to the registered endpoints or external application objects. Usually JMS is used for the internal communication between distributed agent instances, while HTTP and SOAP is used to access external Web services. The usual processing style is asynchronous using SEDA event queues. However, sometimes synchronous communication is needed. For instance, to handle communication with external synchronous HTTP clients such as Web browsers where requests, e.g. by a Web from, are send through a synchronous channel. In this case the implemented synchronous bridge component dispatches the requests into the asynchronous messaging framework and collects all answers from the internal service nodes, while keeping the synchronous channel with the external service open. After all asynchronous answers have been collected they are send back to the still connected external service.

## 7.2 Platform-Dependent Rule Engines As Execution Environments

Each web-based inference service might run one or more arbitrary rule engines to execute the interchanged rules and events and derive answers on requests. In this subsection we will introduce Prova [7], a highly expressive open-source Semantic Web rule engine which supports complex reaction rule-based workflows, decision logic and dynamic access to external data sources and Java objects.

Prova follows the spirit and design of the recent W3C Semantic Web initiative and combines declarative rules, ontologies and inference with dynamic object-oriented Java API calls and access to external data sources such as relational databases or enterprise applications and IT services. One of the key advantages of Prova is its elegant separation of logic, data access, and computation and its tight integration of Java and Semantic Web technologies. It includes numerous expressive features and logic formalisms such as:
- Easy to use and learn ISO Prolog related scripting syntax

- Well-founded Semantics for Extended Logic Programs with defeasible conflict resolution and linear goal memoization
- Order-sorted polymorphic type systems compatible with Java and Semantic Web ontology languages RDF/RDFS and OWL
- Seamless integration of dynamic Java API invocations
- External data access by e.g., SQL, XQuery, RDF triple queries, SPARQL
- Meta-data annotated modular rule sets with expressive transactional updates, Web imports, constructive views and scoped reasoning for distributed rule bases in open environment such as the Web
- Verification, Validation and Integrity tests by integrity constraints and test cases
- Messaging reaction rules for workflow like communication patterns based on the Prova Agent Architecture
- Global reaction rules based on the ECA approach
- Rich libraries and built-ins for e.g. math, date, time, string, interval, list functions For a detailed description of the syntax, semantics and implementation see [15, 7].
8. CONCLUSION
Flexibility in dynamically composing new business processes and integrating heterogenous information systems (HIS), enabling ad-hoc cooperations, is one of the main aims of the recent service oriented computing (SOC) paradigm. The vision is to build largescale service supply chains (a.k.a. business services networks)
which enable enterprises to define and execute Web Services based transactions and business processes across multiple business entities and domain boundaries using standardized (Web) protocols.

In this paper we propose a logic-based homogenous reaction rule language and a rule and event-based middleware which combine technologies from declarative rule-based programming with enterprise application technologies for CEP and SOC. The rulebased approach follows the separation-of-concerns principle and addresses imperatives businesses face today: Deploy the business logic in a service-oriented declarative way, effectively detect, communicate and adequately react to occurred complex events in the business and service management processes, change the decision and behavioral business logic which underpins their applications and service offerings in order to adapt to a flexible business environment (e.g. on-demand/utility computing), and to overcome the restrictive nature of slow IT change cycles. Our rule-based approach has the potential to profoundly change the way IT services are used and collaborate in business processes. Akin to multiagent systems (MAS), the rule-based logic layer allows for intelligent semi-autonomous decisions and reactions which are necessary, e.g., for IT service management (ITSM) processes such as service level management (SLM), change management, availability management and business process management (BPM) such as