platform independent rule interchange format and XML serialization language. In section 6 we implement a highly scalable and efficient communication and management middleware which allows deploying rule inference services for rule-based complex event processing and service-oriented computing on the Web. Section 7 concludes this paper with a discussion of our rule-based design artifact for application domains such as IT Service Management
(ITSM), Business Activity Monitoring (BAM) and Business Process Management (BPM), and Service Oriented Computing.

## 2. Global Reaction Rules

Global reaction rules typically follow the Event-Condition-Action
(ECA) paradigm: "*on Event and Condition do Action*". We have implemented a tight integration of global ECA rules and derivation rules. Both rule types are represented together in a homogeneous knowledge base (KB): KB =*< R, E, F, I >*, where R is the set of derivation rules, E the set of ECA rules, F the set of facts and I the set of integrity constraints. The KB might be updated over time, i.e. the intensional and extensional knowledge might be changed dynamically during runtime incorporating self-updates (add/remove) triggered by active rules or imports of external modules. The approach is based on the logic programming paradigm where the KB is an extended logic program (ELP)
with finite function nestings, variables, (non-monotonic) default negation and explicit negation, a typed logic supporting Semantic Web types from external ontologies (RDFS/OWL) [15, 14] and external Java types and procedural attachments using Java objects/methods in rule derivations [8, 6]. In the following we use the standard LP notation with an ISO Prolog related scripting syntax called Prova [8, 6]. We assume that the reader is familiar with logic programming techniques [9].

## 2.1 Syntax Of Global Eca Rules A Global Reaction Rule Is Formalized As An Extended Eca Rule,

represented in the KB as a 6-ary fact with the reserved predicate name eca: eca(*T, E, C, A, P, EL*), where T (time), E (event), C (condition), A (action), P (post condition), EL(se) are complex terms/functions [10]. The complex terms are meta-interpreted by the ECA interpreter as (sub)goals on derivation rules in the KB which are used to implement the functionality of each part of an ECA rule. That is, the full expressiveness of derivation rules in extended LPs with logical connectives, variables, finite function nestings, (non-monotonic) default and explicit negation as well as linear sequential operators such as "cuts", serial updates and procedural attachments can be used to declaratively implement arbitrary complex behavioural reaction logic, whereas the core ECA rules' syntax stays compact. The implemented global derivation rules can be reused several times in different ECA rules, leading to a compact homogenous rule base (modularization).

The time part (T) of an ECA rule defines a pre-condition (an explicitly stated temporal event defining a validity time or event processing window) which specifies a specific point or window of time at which the ECA rule should be processed by the ECA
processor, either absolutely (e.g., "at 1 o'clock on the 1st of May 2006), relatively (e.g., 1 minute after event X was detected) or periodically ("e.g., "every 10 seconds"). The post-condition (P)
is evaluated after the action has been executed. It might be used to prevent backtracking from different variable bindings via cuts or it might be used to apply post-conditional integrity and verification/validation tests in order to safeguard transactional knowledge updates in ECA rules. The else part (EL) defines an alternative action which is executed in case the ECA rule could not be completely executed. This is in particular useful to specify default (re-)actions or trigger exceptional failure handling policies. The parts of a reaction rule might be blank, i.e.

always satisfied, stated with " ", e.g., eca(t, e, *, a,* , ). Blank parts might be completely omitted leading to specific types of reactive rules, e.g. standard ECA rules (ECA: eca(*e, c, a*) ), production style rules (CA: eca(*c, a*) ), extended ECA rules with post conditions (ECAP: eca(*e, c, a, p*) ). Variable bindings to ground knowledge which is derived from the queried derivation rules or the queried external data sources (e.g. a relational database or constructive procedural function/method) are supported together with unification and backtracking as in logic programming, e.g., eca(detect(e1(Context), T ime), , f ire(a1(Context)*, T ime*)). This is in particular useful to interchange context information, e.g. between the event and the action or the condition and the action part. Negation is supported, e.g., eca(not(ping(*service*1))*, neg*(
maintenance(*service*1)), create(troubleticket(*service*1))). The event of this ECA rule is detected if the ping (might be an external web service call) fails by default, i.e. the (invoke) call on the external procedural function fails or no answer is received
(i.e. the information is missing). If the condition can be explicitly proved as false, i.e. *service*1 is definitely not in maintenance state, a trouble ticket for this unavailable service is automatically created.

Example: *Every 10 seconds it is checked (time) whether there is* a service request by a customer (event). If there is a service request a list of all currently unloaded servers is created (condition) and the service is loaded to the first server (ac-tion). In case this action fails, the system will backtrack and try to load the service to the next server in the list. Otherwise it succeeds and further backtracking is prevented (post-condition cut) . If no unloaded server can be found, the else action is triggered, sending a notification to the customer.

eca( every10Sec(), % time detect(request(Customer, Service),T), % event find(Server), % condition load(Server, Service), % action
!, % postcondition notify(Customer, "Service request temporarily rejected").

).

% time every10Sec() :- sysTime(T), interval( timespan(0,0,0,10),T). % event detect(request(Customer, Service),T):-
occurs(request(Customer,Service),T), consume(request(Customer,Service)).

% condition find(Server) :- sysTime(T), holdsAt(status(Server, unloaded),T). % action load(Server, Service) :-
sysTime(T), rbsla.utils.WebService.load(Server,Service),%proc. attachment add(key(Server), "happens(loading(_0),_1).", [Server, T]).

% alternative action notify(Customer, Message):-
sendMessage(Customer, Message).

The state of each server might be managed via an Event Calculus (EC) formalization:

## Terminates(Loading(Server),Status(Server,Unloaded),T). Initiates(Unloading(Server),Status(Server,Unloaded),T).

The example includes possible backtracking to different variable bindings. In the condition part all servers that are in the state *unloaded* are bound to the variable *Server*. If the action which tries to load a server with the service succeeds, further backtracking is prevented by the post-condition cut. If no unloaded server can be found for the customer request, the "else" action is executed which notifies the customer.

## 2.2 Declarative Semantics Of Global Eca Rules

The declarative semantics of ECA rules is directly inherited from the semantics of the underlying rule/inference system. The goals/queries defined by the (truth-valued model-theoretic) functions denoting the ECA rule parts are actively used to query the KB and evaluate the derivation rules (or external Boolean-valued function implementations) that implement the functionality of the ECA rule parts.

Definition: An extended ECA rule is interpreted as a conjunction of (sub)goals (its complex terms) which must be processed in a left-to-right order starting with the goal denoting the time part, in order to capture the forward-directed semantics of an ECA rule:
ECAi = T ∧E∧((C∧A∧P )∨EL), where ECA *is the top goal/query* which consists of the subgoals T,E,C,A,P ,EL. An ECA rule succeeds, i.e. ECAi *is entailed by the KB, if the subgoals succeed:*
KB |= ECAi iff KB |= (∀X)(T ∧ E ∧ ((C ∧ A ∧ P ) ∨ EL))*, where* X is the set of variables occurring free in ECAi.