The post-condition acts as a constraint on the KB state after the action has been performed. In particular, actions with effects on the KB such as knowledge updates which transit the current KB state to the next state can be tested by integrity constraints. If the integrity tests fail, transactional knowledge updates are rolled back according to the semantics of the transaction logic in our approach. In case of external actions, compensating actions can be called in the else part, if the external system provides appropriate API methods which support transactions. That is, the action part A of a reaction rule can lead to overall rule success only if, besides *success*(A), the (pre)condition before the action and the postcondition after the action are evaluated to true: ∀X(C ∧ *success*(A) ∧ P). For a detailed description of the declarative semantics, in particular the implemented extended well-founded semantics for ELPs see [15].

## 2.3 Operational Semantics Of Global Eca Rules In Order To Integrate The (Re)Active Behavior Of Eca Rules Into

goal-driven backward-reasoning, the goals defined by the complex terms in the ECA rules are meta-interpreted by an additional ECA interpreter. The interpreter implements the forwarddirected operational semantics of the ECA paradigm. The ECA
interpreter provides a general wrapper interface which can be specialized to a particular query API of an arbitrary backwardreasoning inference engine. This means, the ECA meta-interpreter is used as a general add-on attached to an LP system (a derivation rule engine) extending it with reasoning and processing features for reactive rules. The task of processing an ECA rule by querying the respective derivation rules using the defined complex terms in an ECA rule as queries on the KB is solved by a daemon (implemented within the ECA interpreter). The daemon is a kind of adapter that frequently issues queries on the ECA rules in order to simulate the active behavior in passive goal-driven LP systems. Proof-theoretically, it applies the ECA subgoals of a top query formed by an ECA rule one by one on the KB
(the current KB state) using the inference rules of the underlying backward-reasoning inference engine to deductively prove the syntactic derivability from the clauses in the KB. The process is as follows:
1. it queries (repeatedly - in order to capture updates to reactive rules) the KB and derives all ECA rules represented in the KB
by the universal query eca(*T , E, C, A, P, EL*)?,
2. it adds the derived ECA rules to its internal active KB, which is a kind of volatile storage for reactive rules and temporal event data, and 3. finally, it processes the ECA rules sequentially or in parallel, depending on the configuration, using a thread pool.

The forward-directed execution of the ECA paradigm is given by the strictly positional order of the terms in the ECA rules.

That is, first the time part is queried/evaluated by the ECA processor (daemon), when it succeeds then the event part is evaluated, then the condition, and so on. The computed (ground)
substitutions θ of the variables for each subgoal in a rule ECAi are unified by the ECA interpreter with their variable variants in the subsequent subgoals of the top ECA query. The interpreter also implements the common LP backtracking mechanism to backtrack to different variable bindings. In order to enable parallel processing of ECA rules, the ECA processor implements a thread pool where each ECA rule is executed in a separate thread, if its time part succeeds.

Example: "Every 10 seconds it is checked (time) whether there is an incoming request by a customer to book a flight to a certain destination (event). Whenever this event is detected, a database look-up selects a list of all flights to this destination (condition) and tries to book the first flight (action). In case this action fails, the system will backtrack and book the next flight in the list; otherwise it succeeds (post-condition cut) sending a "flight booked" notification.

If no flight can be found to this destination, i.e. the condition fails, the else action is triggered, sending a "booked up" notification back to the customer."
eca( every10Sec(), detect(request(Customer, Destination),T),
find(Destination, Flight), book(Customer, Flight), !, notify(Customer, bookedUp(Destination) ).

% time derivation rule every10Sec() :- sysTime(T), interval( timespan(0,0,0,10),T). % event derivation rule detect(request(Customer, FlightDestination),T):-
occurs(request(Customer,FlightDestination),T), consume(request(Customer,FlightDestination)).

% condition derivation rule find(Destination,Flight) :-
on_exception(java.sql.SQLException,on_db_exception()), dbopen("flights",DB), sql_select(DB,"flights", [flight, Flight], [where, dest=Destination"]).

% action derivation rule book(Cust, Flight) :-
flight.BookingSystem.book(Flight, Cust),
notify(Cust,flightBooked(Flight)).

% alternative action derivation rule notify(Customer, Message):- sendMessage(Customer, Message).

If the action succeeds further backtracking is prevented by the post-condition cut "!". If no flight can be found for the customer request, the else action is executed which notifies the customer about this. The condition derivation rule accesses an external data source via an SQL query to a relational data base.

The homogeneous combination of global ECA-style reaction rules and derivation rules within the same representation language paves the way to the (re-)use of various other useful logic formalisms in reactive rules, such as procedural attachments, defeasible rules with rule priorities for conflict resolution, transactional update actions, event/action logics for temporal event calculations and complex event/action reasoning. Moreover, it relates ECA rules to other rule types such as integrity constraints or normative rules. As a result, the high expressive power and the clear logical semantics of these formalisms is also accessible to reaction rules.

## 3. Interval-Based Event Calculus Event / Action Algebra

Events and actions in reactive ECA rules are typically not atomic but complex, consisting of several atomic events or actions that must occur or be performed in the defined order and quantity so as to detect complex events or execute complex actions, e.g. an ordered sequence of events or actions. This topic has been extensively studied in the context of active databases and event algebras, which provide the operators to define complex event types.

As we have pointed out in [11] typical event algebras of active database systems for complex event definitions such as Snoop [4]
show inconsistencies and irregularities in their operators. For instance, consider the sequence B; (A; C) in Snoop. The complex event is detected if A occurs first, and then B followed by C,
i.e. an event instance sequence (EIS) EIS = *a, b, c* will lead to the detection of the complex event, because the complex event
(A; C) is detected with associated detection time of the terminating event c and accordingly the event b occurs before the detected complex event (A; C). However, this is not the intended semantics: Only the sequence EIS = *b, a, c* should lead to the detection of the complex event defined by B; (A; C). In the semantics of Snoop, which uses the detection time of the terminating event as occurrence time of a complex event, both complex event definitions B; (A; C) and A; (B; C) are equal. This problem arises from the fact that the events, in the active database sense, are simply detected and treated as if they occur at an atomic instant, in contrast to the durative complex events, in the KR event/action logics sense, which occur over an extended interval.

To overcome such unintended semantics and provide verifiable and traceable complex event computations (resp. complex actions) we have implemented an interval-based Event Calculus
(EC) variant and refined the typical event algebra operators based on it. In the interval-based Event Calculus [11] all events are regarded to occur in a time interval, i.e. an event interval [e1, e2]
occurs during the time interval [t1, t2] where t1 is the occurrence time of e1 and t2 is the occurrence time of e2. In particular, an atomic event occurs in the interval [*t, t*], where t is the occurrence time of the atomic event.