The interval-based EC axioms describe when events / actions occur (transient consumption view), *happen* (non-transient reasoning view) or are *planned* to happen (future abductive view)
within the EC time structure, and which properties (*fluents* or event intervals) are *initiated* and/or *terminated* by these events under various circumstances.

Definition: (Interval-based Event Calculus Language) An intervalbased EC signature is a multi-sorted signature with equality, with a sort E for events, a sort F for fluents (states or event intervals [E1, E2]), and a sort T *for timepoints. An EC language* Σ
EC
is a tuple hE, F , T , ≤i where ≤ *is a partial ordering defined over the* non-empty set T of time points, E *is a non-empty set of events/actions* and F *is a non-empty set of fluents. Timepoints, events/actions* and fluents are n-ary functional literals L or ¬L which might be reified typed functions or external object instantiations, e.g. constructive views over relational databases storing the event occurrences, Java object instances, or XML data such as Common Base Event, or Semantic Web event class instances in RDF or OWL.

The basic *holdsAt* axiom of the classical EC [5] for temporal reasoning about fluents is redefined in the interval-based EC
to the axiom holdsInterval([E1, E2], [T1, T2]) to capture the semantics of event intervals which hold between a time interval:

## Holdsinterval([E1,E2],[T11,T22]):- Event([E1],[T11,T12]), Event([E2],[T21,T22]), [T11,T12]<=[T21,T22], Not(Broken(T12,[E1,E2],T21).

The event function event([Event], [*Interval*]) is a meta-function to translate instantaneous event occurrences into interval-based events: event([E], [*T, T*]) : −occurs(*E, T*). It is also used in the event algebra meta-program to compute complex events from occurred raw events according to their event type definitions. The broken function tests whether the event interval is not broken between the the initiator event and the terminator event by any other explicitly specified terminating event:

## Broken(T1,Interval,T2):- Terminates(Terminator,Interval,[T1,T2]), Event([Terminator],[T11,T12]), T1<T11, T12<T2.

The declarative semantics is given by interpretations which map event intervals [E1, E2] and time intervals [T1, T2] to truth values.

Definition: (Interval-based Event Calculus Interpretation) An interpretation is a mapping I : [T1, T2] x [E1, E2] 7→ {*true, false*}.

Definition: (Event Calculus Satisfaction) An interpretation I satisfies an event interval [E1, E2] at a time interval [T1, T2] if I([E1, E2],
[T1, T2]) = true and I(¬[E1, E2], [T1, T2]) = *false*.

Definition: (Instantiation and Termination*) Let* Σ
EC be an intervalbased EC language, DEC *be a domain description (an EC program)*
in Σ
EC and I *be an interpretation of* Σ
EC *. Then an event interval*
[E1, E2] is instantiated at time point T1 in I *iff there is an event* E1 such that there is a statement in DEC of the form occurs(E1, T1) and a statement in DEC of the form initiates(E1, [E1, E2], T). A
event interval [E1, E2] is terminated at time point T2 in I iff there is an event E2 such that there is a statement in DEC *of the form* occurs(E2, T2) and a statement in DEC of the form *terminates*(E2,
[E1, E2], T).

An interpretation qualifies as a model for a given domain description, if:
Definition: (Event Calculus Model*) Let* Σ
EC be an intervalbased EC language, DEC *be a domain description in* Σ
EC *. An* interpretation I of Σ
EC is a model of DEC iff ∀[E1, E2] ∈ F and T1 ≤ T2 ≤ T3 *the following holds:*
1. If [E1, E2] has not been instantiated or terminated at T2 in I
wrt DEC then I([E1, E2], [T1, T1]) = I([E1, E2], [T3, T3])
2. If [E1, E2] is initiated at T1 in I wrt DEC , and not terminated at T2 the I([E1, E2], [T3, T3]) = *true* 3. If [E1, E2] is terminated at T1 in I wrt DEC and not initiated at T2 then I([E1, E2], [T3, T3]) = *false* The three conditions define the persistence of complex event intervals as time progresses. That is, only events/actions have an effect on the changeable event interval states (condition 1) and the truth value of a complex event state persists until it has been explicitly changed by another terminating event/action (condition 2 and 3). A domain description is consistent if it has a model.

We now define entailment wrt to the meta-program domain description which we have implemented as a logic program:
Definition: (Event Calculus Entailment) Let DEC be an intervalbased EC domain description. A event interval [E1, E2] holds at a time interval [1, T2]T wrt to DEC , written DEC |= *holdsInterval*( [E1, E2], [T1, T2])*, iff for every interpretation* I of DEC , I([E1, E2], [T1, T2]) = true. DEC |= neg(holdsInterval([E1, E2], [T1, T2])) iff I([E1, E2], [T1, T2]) = *false*.

## Example Occurs(A,Datetime(2005,1,1,0,0,1)). Occurs(B,Datetime(2005,1,1,0,0,10)). Query: Holdsinterval([A,B],Interval)? Result: Interval= [Datetime(2005,1,1,0,0,1), Datetime(2005,1,1,0,0,10)]

Based on this interval-based event logics formalism, we now redefine the typical (SNOOP) event algebra operators and treat complex events resp. actions as occurring over an interval rather than in terms of their instantaneous detection times. In short, the basic idea is to split the occurrence interval of a complex event into smaller intervals in which all required component events occur, which leads to the definition of event type patterns in terms of interval-based event detection conditions, e.g. the sequence operator (;) is formalized as follows (A; B; C):

## Detect(E,[T1,T3]):- Holdsinterval([A,B],[T1,T2],[A,B,C]), Holdsinterval([B,C],[T2,T3],[A,B,C]), [T1,T2]<=[T2,T3].

For the complete formalization of the interval-based EC event algebra see the ContractLog KR [15, 13]. In order to make definitions of complex events in terms of event algebra operators more comfortable and remove the burden of defining all interval conditions for a particular complex event type as described above, we have implemented a meta-program which implements an intervalbased EC event algebra in terms of typical event operators:

| Sequence:         | sequence(E1,E2, .., En)   |
|-------------------|---------------------------|
| Disjunction:      | or(E1,E2, .. , En)        |
| Mutual exclusive: | xor(E1,E2,..,En)          |
| Conjunction:      | and(E1,E2,..,En)          |
| Simultaneous:     | concurrent(E1,E2,..,En)   |
| Negation:         | neg([ET1,..,ETn],[E1,E2]) |
| Quantification:   | any(n,E)                  |
| Aperiodic:        | aperiodic(E,[E1,E2])      |

In order to reuse detected complex events in rules, e.g. in ECA
rules or other complex events, they need to be remembered until they are consumed, i.e. the contributing component events of a detected complex event should be consumed after detection of a complex event. This can be achieved via the ID-based update primitives which allow adding or removing knowledge from the KB. We use these update primitives to add detected event occurrences as new transient facts to the KB and consume events which have contributed to the detection of the complex event.

Example

## Detect(E,T):- Event(Sequence(A,B),T), % Detection Condition Add(Eis(E), "Occurs(E,_0).", [T]), % Add E With Key Eis(E) Consume(Eis(A)), Consume(Eis(B)). % Consume All A And B Events

If the detection conditions for the complex event e are fulfilled, the occurrence of the detected event e is added to the KB with the key eis(e) (eis = event instance sequence). Then all events that belong to the type specific event instance sequences of type a and type b are consumed using their ids eis(a) resp. eis(b). Different consumption policies are supported such as "*remove all* events which belong to a particular type specific eis" or "*remove* the first resp. the last event in the eis". If no consume predicate is specified in a detection rule, the events are reused in the detection