of other complex events. The detection rule of a complex event might be used in an ECA rule to trigger the ECA rule.

For space reasons we have only discussed the processing of complex events, but the interval-based event calculus can also used for the definition of complex actions, e.g. to define an ordered sequence of action executions or concurrent actions (actions which must be performed in parallel within a time interval), with a declarative semantics for possibly required rollbacks, as defined above. For more information see [11, 15].

## 4. Eventmessaging Reaction Rules The Eca Rules Described In The Previous Section Are Defined

globally. Such global ECA rules are best suited to represent reaction rules that actively detect or query internal and external events in a global context and trigger reactions. For instance, to actively monitor an external system, data source, or service and to trigger a reaction whenever the system/service becomes unavailable. In a distributed environment with independent system nodes that communicate with each other relative to a certain context (e.g. a workflow, conversation protocol state or complex event situation), event processing requires event notification and communication mechanisms, and often needs to be done in a local context, e.g. a conversation state or (business) process workflow. Systems either communicate events according to a predefined or negotiated communication/coordination protocol or they subscribe to specific event types on a server (publish-subscribe).

In the latter case, the server monitors its environment and upon detecting an atomic or complex event (situation), notifies the concerned clients. Complex events may correspond to pre-defined protocols or be based on event algebras including time-restricted sequences and conjunctions/disjunctions, which permits events like A occurs more than t time units after B to be expressed.

## 4.1 Syntax Of Event Messaging Reaction Rules In Addition To Global Eca-Style Reaction Rules, We Provide A

homogenously-integrated event messaging reaction rule language, called Prova AA [7], that includes constructs for asynchronously sending and receiving event messages via various communication protocols over an enterprise service bus and for specifying reaction rules for processing inbound messages. These messaging reaction rules do not require separate threads for handling multiple conversation situations simultaneously. The main language constructs are: *sendMsg* predicates, reaction *rcvMsg* rules, and rcvMsg or *rcvMult* inline reactions:
sendMsg(XID,Protocol,Agent,Performative,Payload |Context)
rcvMsg(XID,Protocol,From,queryref,Paylod|Context) rcvMult(XID,Protocol,From,queryref,Paylod|Context)
where XID is the conversation identifier (conversation-id) of the conversation to which the message will belong. *Protocol* defines the communication protocol. More than 30 protocols such as JMS, HTTP, SOAP, Jade are supported by the underlying enterprise service bus as efficient and scalable object-broker and communication middleware [10]. *Agent* denotes the target (an agent or service wrapping an instance of a rule engine) of the message. *Performative* describes the pragmatic context in which the message is send. A standard nomenclature of performatives is e.g. the FIPA Agents Communication Language ACL or the BPEL activity vocabulary. *Payload* represents the message content sent in the message envelope. It can be a specific query or answer or a complex interchanged rule base (set of rules and facts).

Example:
% Upload a rule base read from File to the host
% at address Remote via JMS upload_mobile_code(Remote,File) :-
% Opening a file returns an instance
% of java.io.BufferedReader in Reader fopen(File,Reader), Writer = java.io.StringWriter(),
copy(Reader,Writer),
Text = Writer.toString(), % SB will encapsulate the whole content of File Figure 1: Example Rule-Based Workflow

![0_image_0.png](0_image_0.png)

## Sb = Stringbuffer(Text), Sendmsg(Xid,Jms,Remote,Eval,Consult(Sb)).

The example shows a reaction rule that sends a rule base from an external *File* to the agent service *Remote* using JMS as transport protocol. The inline sendMsg reaction rules is locally used within a derivation rule, i.e. only applies in the context of the derivation rule. The corresponding global receiving reaction rule could be:

## Rcvmsg(Xid,Jms,Sender,Eval,[Predicate|Args]):- Derive([Predicate|Args]).

This rule receives all incoming JMS based messages with the pragmatic context *eval* and derives the message content. The list notation [P redicate | *Args*] will match with arbitrary n-ary predicate functions, i.e., it denotes a kind of restricted second order notation since the variable *Predicate* is always bound, but matches to all predicates in the signature of the language with an arbitrary number of arguments *Args*).

## 4.2 Semantics Of Event Messaging Reaction Rules

The semantics treats the send and receive constructs as special built-in literals. The execution flow is stored in a transparently constructed temporal reaction rule that is activated once the message matching the specified pattern in *rcvMsg* has arrived. The engine then continues processing other incoming messages and goals/queries. The temporal rule includes the pattern of the message specified in *rcvMsg* (or *rcvMult*) in the head of the rule and all remaining goals at the current execution point in its body. This behaviour is different from suspending the current thread and waiting for the replies to arrive. The rule engine maintains one main thread while allowing an unlimited number of conversations to proceed at the same time without incurring the penalty and limitations of multiple threads otherwise used solely for the purpose of maintaining several conversation states at the same time.

The conversation and event context based semantics of global and local inline receive and send reaction rules allows implementing typical semantics of state machines or workflow-style systems such as Petri nets or pi-calculus, which can be used for complex event processing and workflow process executions (e.g. in style of BPEL). Figure 1 shows an example of a event-based workflow which is implemented as follows:
process_join() :-
iam(Me),
init_join(XID,join_1,[c(_),b(_)]),
fork_a_b(Me,XID).

fork_a_b(Me,XID) :-
rcvMsg(XID,self,Me,reply,a(1)),
fork_c_d(Me,XID).

fork_a_b(Me,XID) :-
rcvMsg(XID,self,Me,reply,b(1)),
join(Me,XID,join_1,b(1)).

fork_c_d(Me,XID) :-
rcvMsg(XID,self,Me,reply,c(1)),
% Tell the join join_1 that a new pattern is ready join(Me,XID,join_1,c(1)).

% invoked by join once all the inputs are assembled. join_1(Me,XID,Inputs) :-
println(["Joined for XID=",XID," with inputs: ",Inputs]).

% Prints % Joined for XID=agent@hostname001 with inputs [[b,1],[c,1]]