The behaviour of the inbound links defined by the *rcvMsg* reaction rules is similar to BPEL links. However, the declarative rule-based approach provides a much more expressive declarative programming language to represent complex event processing logic, conditional reactions (activities) and complex event-based workflow patterns such as Join, Simple Merge, Cancel Activity, Multi-Choice, Structured Loop, Deferred Choice and Milestone
(see [6] for an implementation). The homogenous language approach allows arbitrary combinations of logic and meta-logic programming formalisms with global ECA and context-specific messaging reaction rules.

The following example demonstrates the use of messaging reaction rules for detecting a complex event pattern that includes event sequencing, disjunction, and event branching that depends on non-arrival of specified events: Event pattern is A; (¬B∗*B or* ¬E∗C); D, where '∗' denotes 0..∗ instances of the messages it follows.

## Rcvmsg(Xid,Protocol,Sender,Inform,A) :- Partition_Id(Id1), Partition_Id (Id2), Detect_Bc(Xid,Id1,Id2), Rcvmsg(Xid,Protocol,Sender,Inform,D),

% inform the clients here about the detected situation ...

detect_bc(XID,ID1,ID2) :-
rcvMsgP([ID1],[ID1],rcvMsg(XID,Protocol,Sender,inform,B)).

detect_bc(XID,ID1,ID2) :-
rcvMsgP([ID1,ID2],[ID1],rcvMsg(XID,Protocol,Sender,inform,C)).

detect_bc(XID,ID1,ID2) :-
rcvMsgP([ID1],[ID2],rcvMsg(XID,Protocol,Sender,inform,E)), fail().

In the example, message A is the initiator of the complex event situation and has a reaction rule *rcvMsg* beginning the situation detection. This reaction rule is executed whenever a node receives a message with correlation-id XID on *P rotocol* from *Sender* with payload matching the pattern A. The subsequent events contain two intersecting detection partitions (ID1 and ID2) that are active whenever the reactions to corresponding events are enabled.

For example, the reaction to event C is only enabled while both partitions are active. The built-ins *partition* id generate unique id's for each partition. The rules for the predicate *detect* bc spawn three reactions represented by the built-in *rcvMsgP* representing inline detection of events depending on inbound and outbound partition links. This behaviour is similar but opposite to BPEL
links. Outbound links (argument 2 of *rcvMsgP*) represent partitions that become inactive once the message matching the pattern in argument 3 of *rcvMsgP* is received. Inbound links (argument 1 of *rcvMsgP*) represent the partitions that must be active for the reaction to be active. Inactive reactions are removed from the system. Consider now the EIS{A; E; B; D}. The initiator A is detected by the first rule and three reactions for events B,
C and D are activated. The event E deactivates the partition ID2 which removes the branches waiting for the event C and E. The event B succeeds the first *detect* bc rule while the last event D is received by the built-in reaction *rcvMsg* that waits for this event skipping any events that do not match. The example demonstrates that the semantics of complex event detection should fully respect the mutual ordering of events and also allow for flexibility in allowing or disallowing intervening events in conditional branches. The messaging reaction rules can also easily detect conjunctions of events (not shown here due to the lack of space).

In summary, the messaging style reaction rules complement the global ECA rules. We will now illustrate the combination of active global ECA and messaging reaction rules by a typical use case found in industry:
Example: *A Manager node is responsible for holding housekeeping information about various servers playing different roles. When* a server fails to send a heartbeat for a specified amount of time, the Manager assumes that the server failed and cooperates with the Agent component running on an unloaded node to resurrect it. A reaction rule for receiving and updating the latest heartbeat in event notification style is: rcvMsg(XID,Protocol,FromIP,inform,heartbeat(Role,RemoteTime)) :-
time(LocalTime)
update(key(FromIP,Role),"heartbeats(_0, _1, _2, _3).",
[ FromIP, Role, RemoteTime, LocalTime] ).

The rule responds to a message pattern matching the one specified in the *rcvMsg* arguments. XID is the conversation-id of the incoming message; *inform* is the performative representing the pragmatic context of the message, in this case, a one-way information passed between parties; *heartbeat(...)* is the payload of the message. The body of the rule enquires about the current local time and updates the record containing the latest heartbeat from the controller. This rule follows a push pattern where the event is pushed towards the rule systems and the latter reacts. A
pull-based global ECA rule that is activated every second by the rule engine and for each server that fails to have sent heartbeats within the last second will detect server failures and respond to it by initiating failover to the first available unloaded server. The accompanying derivation rules *detect* and *respond* are used for specific purpose of detecting the failure and organizing the response.

eca( every('1S') , detect(controller_failure(IP,Role,'1S')) , respond(controller_failure(IP,Role,'1S')) ) .

every('1S'):-
sysTime(T),
interval(timespan(0,0,0,1),T).

detect(controller_failure(IP,Role,Timeout)) :-
sysTime(LocalTimeNow),
heartbeats(IP,Role,RemoteTime,LocalTime), LocalTimeNow-LocalTime > Timeout.

respond(controller_failure(IP,Role,Timeout)) :-
sysTime(LocalTime), first(holdsAt(status(Server,unloaded),LocalTime)),
add(key(Server),
"happens(loading(_0),_1).",[ Server, Local-Time]),
sendMsg(XID,loopback,self,initiate,failover(Role,IP,Server)).

The ECA logic involves possible backtracking so that all failed components will be resurrected. The state of each server is managed via an event calculus formulation:

## Initiates(Loading(Server),Status(Server,Loaded),T). Terminates(Unloading(Server),Status(Server,Loaded),T). Initiates(Unloading(Server),Status(Server,Unloaded),T). Terminates(Loading(Server),Status(Server, Loaded),T). The Current State Of Each Server Is Derived From The Happened Loading And Unloading Events And Used In The Eca Rule To Detect The First Server Which Is In State Unloaded. This Ec Based Formalization Can Be Easily Extended, E.G. With New States Such As A Maintenance State Which Terminates An Unloaded State, But Is Not Allowed In Case A Server Is Already Loaded: Initiates(Maintaining(Server),Status(Server,Maintenance),T):- Not(Holdsat(Status(Server,Loaded),T)). Terminates(Maintaining(Server),Status(Server,Unloaded),T). In Summary, The Messaging Style Reaction Rules Complement The Global Eca Rules In Distributed Coordination Situations Such As Process Workflows And For Distributed Complex Event Processing. 5. Transactionalmodule-Based Updates

Our reaction rule language provides support for three special update functions add, *remove* and *transaction* and two auxiliary functions *commit* and *rollback*. These update primitives are more expressive than the simple assert/retract primitives found in typical LP interpreters such as Prolog and allow transactional as well as bulk updates of knowledge including updating of facts and rules. They enable arbitrary knowledge updates, e.g., adding (add) /removing (*remove*) rules or complete rule sets including the import of knowledge from external sources and transactional update (*transaction*) which are rolled back if the execution fails. Transactions might be explicit committed or rolledback. Each update has a unique ID with which it is asserted into the KB