as a module, i.e. the KB is an ordered LP (OLP) consisting of arbitrary nested and possibly distributed modules (rule sets)
managed by their unique ID. Preferences with e.g. default rules and priorities might be defined between rules and complete modules by an expressive integrity-preserving defeasible logic. Constructive scopes can be used to constrain the level of generality of queries and explicitly close of open distributed KBs to support non-monotonic properties, e.g. for negation-as-failure. For a detailed description of these expressive logic formalisms see the ContractLog KR [15, 13].

add("./examples/test/test.prova") % add an external script add("http://rbsla.com/ContractLog/datetime.prova") % from URL
add(id1,"r(1):-f(1). f(1).")% add rule and fact add(id2,"r(X):-f(X).") % add rule "r(X):-f(X)." p(X,Y) :- % object/variable place holders _N: _0=X ; _1=Y.

add(id3,"r(_0):-f(_0), g(_0). f(_0). g(_1).",[X,Y]).

remove(id1) % remove all updates with id remove("./examples/test/test.prova") % remove external update The examples show different variants of updates with external modules imported from their URIs, user-defined updates asserting rules and facts and updates with previously bound variables from other goals which are integrated into the updates using place holders X.

Remarkably, updates to the KB are handled as modules, i.e.,
as (smaller) logic programs which might contain further updates and imports of other modules, leading to nested updates with hierarchical submodules. External LP scripts can be dynamically added and removed from the knowledge base using their module object ids (typically the URI or an user defined label).

The semantics of updates in ContractLog is based on the notion of knowledge states and transitions from one state to another.

Definition: (Positive Update Transition) A positive update transition, or simply positive update, to a knowledge state KBk *is defined as a finite set* U
pos oid := {rN : H ← B, factM : A ←} *with* A an atom denoting a fact, H ← B *a rule,* N = 0, .., n and M = 0*, ..m* and oid *being the update oid which is also used as module oid* to manage the knowledge as a new module in the KB. Applying U
pos oid to KBk *leads to the extended state* KBk+1 = {KBk ∪ U
pos oid }.

Applying several positive updates as an increasing finite sequence U
pos oidj with j = 0, .., k and U
pos oid0
:= ∅ to KB0 *leads to a state* KBk = {KB0 ∪ U
pos oid0
∪ U
pos oid1
∪ ... ∪ U
pos oidk
}.

Likewise, we define a *negative update transition* as follows:
Definition: (Negative Update Transition) A negative update transition, or for short a negative update, to a knowledge state KBk is a finite set U
neg oid := {rN : H ← B, factM : A ←} *with* A ∈ KBk, H ← B ∈ P , N = 0, .., n and M = 0, ..m*, which is removed from* KBk*, leading to the reduced program* KBk+1 = {KBk \ U
neg oid }.

Applying arbitrary sequences of positive and negative updates leads to a sequence of KB states KB0*, .., KB*k where each state KBi is defined by either KBi = KBi−1 ∪ U
pos oidi or KBi =
KBi−1 \ U
neg oidi
.

Transactional updates in our rule language are inspired by the serial Horn version of transaction logics (TR) [3].

Definition: (Transactional Update*) A transactional update is an* update, possibly consisting of several atomic updates, which must be executed completely or not at all. In case a transactional update fails, i.e., it is only partially executed or violates integrity wrt to integrity constraints, it will be rolled back otherwise it will be committed. Formally, a transactional update is defined as follows:
U
trans oid := U
pos/neg oid1, .., U*pos/neg* oidn&IC
, where IC = {IC1, .., ICm} is a possibly empty set of integrity constraints which must hold after the update has been executed. In case an integrity constraint is violated the update is rolled back.

A roll back to the previous state before the update means to apply the complement update function on the added or removed modules:
Definition:(Rollback of Update) A transactional update is rolled back by inverting the update primitive:
KBi = KBi+1 \ U
trans oid iff KBi+1 = KBi ∪ U
trans oid KBi = KBi+1 ∪ U
trans oid *iff exists* KBi+1 = KBi \ U
trans oid Note, that due to the module concept in our language only the transition sequence consisting of the update state oids and the update primitive needs to be remembered to rollback a sequence of transactional updates.

The declarative semantics of transactional updates is built on the concept of sequences of state transitions hKB1*, ..., KB*ki. The truths of update are defined on transition paths, i.e. the answer to a query is not determined by the current knowledge base alone, but depends on the entire transition paths. That is, only paths which return a non-empty answer respectively succeed in case of propositional queries are considered and their executed transactional updates are committed, whereas paths with empty answer sets are backtracked and the processed transactional updates within such paths are rolled back to the state of the last backtracking point. A query fails if the set of answers is empty for every possible transition path. The logical account of transactional execution (derivation with transactional updates) is given by the concept of executional entailment adapted from TR.

Definition: (Executional Entailment) Let KB0 be an initial KB
state and Q be a query which might contain free variables X1*, .., X*n then KB0, π |= Q, i.e., Q is true in KB0*, iff there exists a path* π =
hKB0, .., KBki which returns a non-empty answer for all variables in Q. Q fails if it returns an empty answer set for every possible execution paths πi.

That is, a query involves a mapping from sequences of KB
states to sets of tuples of ground terms in each state. In case of free queries with variables several transition paths are considered to produce answers for the query Q, then the final state KB
which becomes the new knowledge base (state) is the union of all final states of valid transition paths πi which entail Q. Queries which do not involve any updates, i.e., which do not consider serial update rules but only LP rules with standard literals without any side effects on the KB, have an transition path with length k = 0.

In this case, a goal Q is entailed if *KB, π* |= Q and π = {KB}, i.e.,
there is no state transition and accordingly executional entailment reduces to standard LP entailment KB |= Q.

## 6. Integration Of Reaction Rules Into Ruleml

In this section we propose a reaction rule extension, called Reaction RuleML, to RuleML, as a standard for rule interchange and rule serialization in XML. Reaction RuleML serves as a platformindependent rule interchange format, and is intended to be translated into platform-specific, executable rule languages such as our homogenous reaction rule language which we described in the previous sections.

The **Rule Markup Language** (RuleML) [1] is a modular, interchangeable rule specification standard to express both forward
(bottom-up) and backward (top-down) rules for deduction, reaction, rewriting, and further inferential-transformational tasks.

It is defined by the Rule Markup Initiative [2], an open network of individuals and groups from both industry and academia that was formed to develop a canonical Web language for rule serialization using XML and for transformation from and to other rule standards/systems. The language family of RuleML covers the entire rule spectrum, from derivation rules to reaction rules including rule-based event processing and messaging (Reaction RuleML [18]), as well as verification and transformation rules. In the following, we will briefly summarize the key components of the Derivation RuleML language (Horn logic layer), and then introduce the Reaction RuleML sublanguage [18] which extends RuleML with additional language constructs for representing reaction rules and complex event / action messages. The building blocks of Derivation RuleML are: [1]
- Predicates are n-ary relations introduced via an *< Atom >*
element in RuleML. The main terms within an atom are variables *< V ar >* to be instantiated by values when the rules are applied, individual constants *< Ind >*, data values *< Data >*, and complex expressions *< Expr >*.

- Derivation Rules are defined by an *< Implies >* element which consists of a body part (*< body >*) with one or more atomic