conditions connected via < And > or *< Or >*, possibly negated by *< Neg >* (for classical negation) or *< Naf >* (for negation as failure), and of a conclusion part (*< head >*) that is implied by the body, where rule application can be in a forward or backward manner.

- Facts are stated as atoms deemed to be true: *< Atom >* - Queries *< Query >* can be proven backward as top-down goals or forward via bottom-up processing, where several goals may be connected within a query, possibly negated.

Besides facts, derivation rules, and queries, RuleML defines further rule types such as integrity constraints and transformation rules [1].

Reaction RuleML [18] is a general, practical, compact and user-friendly XML-serialized sublanguage of RuleML for the family of reaction rules. It incorporates various kinds of production, action, reaction, and KR temporal/event/action logic rules as well as (complex) event/action messages into the native RuleML syntax using a system of step-wise extensions. The building blocks of Reaction RuleML (v0.2) are: [18]
- One general (reaction) rule form (*< Rule >*) that can be specialized by the selection of the constituent subparts to, e.g.

Condition-Action rules (production rules), Event-Action rules
(trigger rules), Event-Condition-Action rules ...

- Three execution styles defined by the attribute @*execution*;
default value is "reasoning".

- *active*: 'actively' polls/detects occurred events in global ECA style, e.g. by a ping on a service/system or a query on an internal or external event database
- *messaging*: waits for incoming complex event message
(inbound) and sends messages (outbound) as actions
- *reasoning*: Logical reasoning as e.g., in logic programming (derivation rules) and KR formalisms such as event/
action/transition logics (as e.g. in Event Calculus, Situation Calculus, TAL formalizations)
- "weak" and "strong" evaluation/execution semantics ("@eval")
interpretation which are used to manage the "justification lifecycle" of local inner reaction rules in the derivation/execution process of the outer rules
- optional object identifier (oid)
- an optional metadata label (*label*) with e.g. metadata authoring information such as rule name, author, creation date, source
...

- an optional set of qualifications (*qualification*) such as a validity value, fuzzy value, a defeasible priority value... - Messages *< Message >* define inbound or outbound event message A reaction rule might apply globally as e.g. global ECA rules or locally nested within other reaction or derivation rules as e.g. in the case of serial messaging reaction rules. The most general syntax of a (reaction) rules is:
<Rule execution="active" eval="strong">
<oid> <!-- object identifier --> </oid> <label> <!-- metadata --> </label> <qualification> <!-- qualifications --> </qualification> <on> <!-- event --> </on> <if> <!-- condition --> </if>
<then> <!-- conclusion --> </then>
<do> <!-- action --> </do> <after> <!-- postcondition --> </after>
<else> <!-- else conclusion --> </else>
<elseDo> <!-- else/alternative action --> </elseDo> <elseAfter> <!-- else postcondition --> </elseAfter>
</Rule>
According to the selected and omitted rule parts a rule specializes, e.g. to a derivation rule (if-then or if-then-else; reasoning style), a trigger rule (on-do), a production rule (if-do), an ECA rule (on-if-do) and special cases such as ECAP rule (on-ifdo-after) or mixed rule types such as derivation rule with alternative action (if-then-elseDo), e.g. to trigger an update action
(add/remove from KB) or send an event message (e.g. to a log system) in case a query on the if-then derivation rule fails.

Complex event algebra constructs such as < Sequence >, <
Disjunction >,< Conjunction >, < Xor >, *< Concurrent >*,
< N ot >, < Any >, < Aperiodic >, *< P eriodic >* and complex action algebra constructs such as < Succession >, *< Choice >*, < F low >, *< Loop >* can be used in the event respective action part to define complex event types and complex actions.

The metadata label can be optionally used to add additional metadata using Semantic Web / metadata vocabularies such as Dublin Core. The rule quantifications such as priorities or validity values form the basis for expressive reasoning formalisms such as defeasible logic, argumentation semantics, scoped reasoning or fuzzy reasoning (see e.g. [15]).

In messaging style inbound and outbound messages *< Message >* are used to interchange events (e.g. queries and answers) and rules:

## <Message Mode="Outbound" Directive="Acl:Inform"> <Oid> <!-- Conversation Id--> </Oid> <Protocol> <!-- Transport Protocol --> </Protocol>

<sender> <!-- sender agent/service --> </sender>
<content> <!-- message payload --> </content>
</Message>
- @mode = inbound|*outbound* - attribute defining the type of a message
- @*directive* - attribute defining the pragmatic context of the message, e.g. a FIPA ACL performative
- *< oid >* - the conversation id used to distinguish multiple conversations and conversation states
- *< protocol >* - a transport protocol such as HTTP, JMS,
SOAP, Jade, Enterprise Service Bus (ESB) ...

- *< sender >< receiver >* - the sender/receiver agent/service of the message
- *< content >* - message payload transporting a RuleML / Reaction RuleML query, answer or rule base The directive attribute corresponds to the pragmatic instruction, i.e. the pragmatic characterization of the message context.

External vocabularies defining pragmatic performatives might be used by pointing to their conceptual descriptions. A standard nomenclature of pragmatic performatives is defined by the Knowledge Query Manipulation Language (KQML) and the FIPA Agent Communication Language (ACL) which defines several speech act theory-based communicative acts. Other vocabularies such as the normative concepts of Standard Deontic Logic, e.g., to define action obligations or permissions and prohibitions might be used as well.

The conversation identifier is used to distinguish multiple conversations and conversation states. This allows to associate messages as follow-up to previously existing conversations, e.g. to implement complex coordination and negotiation protocols. For an overview and description of several negotiation and coordination protocols see [17].

The protocol might define lower-level ad-hoc or ESB transport protocols such as HTTP, JMS, SOAP or e.g. agent-oriented communication protocols such as Jade.

The content of a message might be a query or answer or a larger rule or fact base serialized in RuleML / Reaction RuleML.

RuleMLs' webized typing approach enables the integration of rich external syntactic and semantic domain vocabularies into the compact RuleML language. For instance, the following example shows a Reaction RuleML message with a IBM Common Base Event (CBE) formalization as payload.

Example
<Message mode="outbound" directive="ACL:inform">
<oid><Ind>conversation123</Ind></oid>
<protocol><Ind>esb</Ind></protocol> <sender><Ind>server32@lapbichler32</Ind></sender>
<receiver><Ind>client11@lapbichler32</Ind></receiver>
<content>
<And>
<Atom>
<oid>
<Ind type="cbe:CommonBaseEvent">i000000</Ind>
</oid>