Theorem 3. The probability of a matrix D **under the MaxEnt distribution**
subject to equality constraints on the expected row and column sums is invariant under allowed δ**-swaps applied to** D.

Proof. **It is easily verified from Eq. (15) that:**

$$P_{ij}({\bf D}(i,j))\cdot P_{il}({\bf D}(i,l))\cdot P_{kj}({\bf D}(k,j))\cdot P_{kl}({\bf D}(k,l))$$ $$=P_{ij}({\bf D}(i,j)+\delta)\cdot P_{il}({\bf D}(i,l)-\delta)\cdot P_{kj}({\bf D}(k,j)-\delta)\cdot P_{kl}({\bf D}(k,l)+\delta)$$  for any $\delta$, rows $i,k$ and columns $j,l$.  
This means that for any 2 × 2 submatrix of D**, adding a given number to its**
diagonal and subtracting the same number from its off-diagonal elements leaves the total probability of the data under the MaxEnt model invariant.

More generally, the MaxEnt distribution assigns the same probability **to any**
two matrices that have the same row and column sums. This can be seen from the fact that Eq. (12) is independent from D **as soon as the row and column**
sums Pj D(i, j) and Pi D(i, j**) are given. In statistical terms: the row and**
column sums are sufficient statistics of the data D **for the MaxEnt distribution.**
We can formalize this in the following Theorem:
Theorem 4. The MaxEnt distribution for a matrix D**, conditioned on constraints on row and column sums of the form**

$$\begin{array}{r c l}{{\sum_{j}\mathbf{D}(i,j)}}&{{=}}&{{d_{i}^{r},}}\\ {{}}&{{}}&{{}}\\ {{\sum_{i}\mathbf{D}(i,j)}}&{{=}}&{{d_{j}^{c},}}\end{array}$$

denoted as P(D|Pj D(i, j) = d r i
,Pi D(i, j) = d c j
)**, is identical to the uniform**
distribution over all databases satisfying these constraints.

This Theorem further clarifies the connection between the uniform **distribution over all matrices with fixed row and column sums, as sampled from**
in Gionis et al (2007); Ojala et al (2008) using swap randomizations, **and the** MaxEnt distribution.

## 4.2 Special Cases Of Δ**-Swaps**

The invariants that have been used before in computation intensive **approaches** for defining null models for databases are special cases of these more generally applicable δ**-swaps.**
For binary databases the condition D(i, j)+δ, D(k, j)−δ, D(i, l)−δ, D(**k, l**)+
δ ∈ D corresponds to the fact that either δ = −1 and D(i, k; j, l) = 1 0

$$\begin{array}{l}{{0\quad\mathrm{s},\Sigma(0,1)\quad\mathrm{s},\Sigma(k,0)=}}\\ {{\vdots,k;j,l)=\left(\begin{array}{l l}{{1}}&{{0}}\\ {{0}}&{{1}}\end{array}\right),\mathrm{or}}}\end{array}$$
$$\delta=1\ \mathrm{and}\ \mathbf{D}(i,k;j,l)={\left(\begin{array}{l l}{0}&{1}\\ {1}&{0}\end{array}\right)}$$

1 0 . Then, the δ**-swap is identical to a swap in a**
binary database. This shows that the MaxEnt distribution of a binary database