
## 1 Introduction 1.1 Prior Work On Subjective Interestingness

Prior information and interestingness of patterns Data mining practitioners commonly have a partial understanding of the structure **of the data**
investigated. The goal of the data mining process is then to discover any additional structure or patterns the data may exhibit. Unfortunately, structure that is trivially implied by the prior information available is often overwhelming, and it is hard to design data mining algorithms that look beyond it.

For example, it should not be seen as a surprise that items known to be frequent in a binary database are jointly part of many transactions, as this is what should be expected even under a model of independence. Rather than discovering such patterns that are implied by prior information, data mining is concerned with discovering departures from this prior information.

Interestingness measures that take into account prior information in this way are commonly referred to as subjective interestingness measures, first introduced as a concept in Silberschatz and Tuzhilin (1995). In contrast with objective interestingness measures (such as the support of an itemset and **the confidence** of an association rule), they do not depend on the data alone but also on the prior information of the data miner. An excellent overview of subjective and objective interestingness measures for data mining can be found in Geng and Hamilton (2006).

To define subjective interestingness measures, the ability to formalize prior information is as important as the ability to contrast patterns with this information thus formalized. In this paper, we mainly focus on the first of **these**
challenges: the task of designing appropriate models incorporating **prior information in data mining contexts. However, we will also outline various possible**
approaches of how such a background model can be used to define **subjective** interestingness measures, and we will demonstrate one in greater **detail on a** practical use case.

Prior work on subjective interestingness measures **Several authors have**
already suggested ways to incorporate prior information in the data mining process for this purpose of defining subjective interestingness measures.

In Silberschatz and Tuzhilin (1995), which introduces the idea of subjective interestingness measures, and in later work (e.g. Padmanabhan and Tuzhilin, 1998, 2000), prior information is formalized as a set of beliefs, each **of which** holds with a certain confidence. The beliefs they consider are of the **form of**
rules X → Y where X and Y **are conjunctions of literals. Patterns in the** form A → B **are then assessed for unexpectedness in a well-defined way with**
respect to each belief. A disadvantage of this approach is that it is local in that each belief is treated independently of the others. Furthermore, **it is specifically** designed for patterns in the form of rules.

An approach that overcomes these problems was proposed in Jaroszewicz and Simovici
(2004), still for binary databases. They propose to use a Bayesian network model