Below we will define a measure of interestingness for tiles and extend **these**
ideas also to sets of tiles. Our approach is based on the second option in Sec. 2.2:
computing the compression ratio of information embodied by the statement that a tile is present in the database. In order to quantify this, we need to quantify two things: the self-information **of a tile pattern with respect to the MaxEnt**
model representing the prior information, and its description length **representing** its complexity as perceived by the data miner.

## 5.2.1 The Self-Information Of A Tile

Let us try to intuitively quantify the amount of information conveyed to a data miner if he is told about the presence of a tile in the database. We argue that it could be formalized by the prior belief the data miner had about the presence or absence of the tile. The most natural way of formalizing this is to use a background distribution representing the data miner's prior expectations, and to compute the probability P r(τ ∈ D**) of the tile-pattern under this distribution.**
The smaller P r(τ ∈ D**), the more information this tile-pattern contains.**
A more convenient way of quantifying this is as the negative log-probability, known as the self-information in Shannon's information theory (Cover and Thomas, 1991):

$$\begin{array}{r c l}{{\mathrm{SelfInformation}(\tau)}}&{{=}}&{{-\log(P r(\tau\in{\bf D})),}}\end{array}$$
SelfInformation(τ) = − log(P r(τ ∈ D)), **(17)**
where the probability is taken with respect to the background distribution. If a pattern is more interesting as its probability is smaller, it is equivalently more interesting as its self-information is larger, since minus the logarithm is a monotonically decreasing function.

The self-information is the number of bits (if a base 2 logarithm is used) that is required to encode a particular outcome of a random variable in a Shannonoptimal code. Here that random variable is the indicator variable indicating presence or absence of the tile in the database. Besides its useful **interpretation** as a code length, the self-information has an important practical advantage over the probability of the presence of the tile as a measure of information content: the logarithm maps extremely small probabilities to numerically more manageable values.

For the MaxEnt model subject to row and column sums, the self-information of a tile pattern can be computed very conveniently by relying on Eqs. (14-16):

$$\mbox{SelfInformation}(\tau)=-\sum_{(i,j)\in\tau}\log(p_{ij}),\tag{18}$$

where

$$p_{ij}=\frac{\exp\left(\lambda_{i}^{r}+\lambda_{j}^{c}\right)}{1+\exp\left(\lambda_{i}^{r}+\lambda_{j}^{c}\right)}.\tag{19}$$

I.e., the self-information is equal to the sum of the negative log-probabilities that the database entry D(i, j) = 1, summed over all row-column pairs (i, j**) in**