A similar connection exists with the so-called p∗ **models from social network**
analysis (Robins et al, 2007). Although motivated differently, the p1 **model in**
particular is formally identical to our MaxEnt model when applied to adjacency matrices for unweighted networks.

Thus, the present paper provides an additional way to look at these widely used models from psychometrics and social network analysis. Furthermore, as we have shown, the MaxEnt approach suggests generalizations, in **particular** towards non-binary databases and weighted networks.

When applied to adjacency matrices of networks, the MaxEnt model is related to random network models for networks with prescribed degree sequences
(see Newman (2003) and references therein). The most similar model to the ones discussed in this paper is the one from Chung and Lu (2004). In this paper, the authors propose to assume that edge occurrences are **independent, with**
each edge probability proportional to the product of the degrees **of the pair of** nodes considered. In the notation of the present paper:

## P(D) = Y I,J P(D(I, J)) With P(D(I, J**)) =** Didj S,

where s =Pi di**. Also for this model the constraints on the expected row and**
column sums are satisfied.

It would be too easy to simply dismiss this model by stating that among all distributions satisfying the expected row and column sum constraints, it is not the maximal entropy one, such that it is biased in some sense. However, this drawback can be made more tangible: the model represents a probability distribution only if maxi,j didj ≤ s**, which is by no means true in all practical**
applications, in particular in power-law graphs. This shortcoming is a symptom of a bias of this model: it disproportionally favors connections between pairs of nodes both of high degree, such that for nodes of too high degrees the edge 'probability' suggested becomes larger than 1. A brief remark considering a similar model for binary databases was made in Gionis et al (2007), where it was dismissed by the authors on similar grounds.

The uses of the maximum entropy principle in statistics are to numerous to list (Jaynes (1957, 1982) are good starting points). Of particular interest to this paper is the prior use of the maximum entropy objective as a regularizer in image reconstruction, and more specifically in computer tomography
(e.g. Gull and Skilling, 1984). Here, the intensity distribution over the image is regarded as a probability distribution, to be inferred from integrals **of this distribution along various paths. This is similar to the MaxEnt model for binary**
databases presented in the current paper, where the paths correspond to the rows and columns.

The maximum entropy principle has also been used before in data mining, albeit it for a different purpose and in a different manner than in this paper
(e.g. not for the incorporation of prior information into a background model). For example in Tatti (2008) the frequency of an itemset was contrasted with an estimate based on the frequency of all its subsets, estimated using the maximum