In this paper, we have introduced a new modeling approach for prior **information based on the maximum entropy principle. Fitting the resulting MaxEnt**
distribution boils down to a well-posed convex optimization problem. We **have** also outlined various ways in which the MaxEnt model can be used to contrast patterns in data with prior information, in order to come up with subjective interestingness measures.

Applying this general framework to rectangular databases and prior information on the row and column sums, it turns out that the MaxEnt model can be represented particularly compactly, and specific properties can be exploited to dramatically enhance computational efficiency. Furthermore, we showed how the MaxEnt model can be used efficiently to sample random databases satisfying the prior information. Finally, we also worked out the details of a new interestingness measure for tiles, referred to as the compression ratio, that takes account of row and column sums as prior information.

In our further work we will investigate other interesting use cases **of the**
general framework laid out in Sec. 2. For example, in line with the alternative randomization strategies suggested in Hanhijarvi et al (2009), we will investigate other types of prior information on rectangular databases, **such as on the**
variance within rows or columns (then the domain of the database elements can be chosen to be D = R **and the resulting MaxEnt distribution would be a product of Gaussian distributions), the support of certain itemsets (for which also**
the ideas from Pavlov et al (2003) and Calders (2008) will prove useful), or an existing cluster structure in the data. Furthermore, the strategy can be applied to other data types as well, such as categorical data (see end of Sec. 5.1). In parallel, we will investigate the use of the MaxEnt modeling strategy for other types of data such as relational databases.

## Acknowledgements

This work is supported by the EPSRC grant EP/G056447/1. The author is grateful to Bart Goethals, Nello Cristianini, Akis Kontonasios, and Eirini Spyropoulou for interesting discussions relating to this work.

## References

Agrawal R, Srikant R (1994) Fast algorithms for mining association rules in large databases. In: Proc. of the 20th International Conference on Very Large Databases (VLDB94), pp 487–499 Asuncion A, Newman D (2007) UCI machine learning repository. In:
http://www.ics.uci.edu/∼**mlearn/MLRepository.html**
Barabasi AL, Albert R (1999) Emergence of scaling in random networks. Science 286(5439):509–512 Boyd S, Vandeberghe L (2004) Convex Optimization. Cambridge University Press