The function Z(λ**) is known as the partition function. This leads to the final** form of the MaxEnt distribution as a function of the Lagrange multipliers λ:

$$\begin{array}{r c l}{{P(\mathbf{x})}}&{{=}}&{{\frac{1}{Z(\boldsymbol{\lambda})}\exp\left(\sum_{i}\lambda_{i}f_{i}(\mathbf{x})\right).}}\end{array}$$
$$\left(7\right)$$

The resulting model is a member of the exponential family of distributions, such that all existing theory for this family of distributions can be used (e.g. Wainwright and Jordan, 2008). The optimal values of the Lagrange **multipliers**
λ **can be found by minimizing the Lagrange dual objective. This Lagrange dual**
is obtained by substituting Eq. (7) for P(x**) in the Lagrangian (Eq. (5)). After**
some algebra:

$$\begin{array}{r c l}{{L(\mathbf{\lambda})}}&{{=}}&{{\log(Z(\mathbf{\lambda}))-\sum_{i}\lambda_{i}d_{i}.}}\end{array}$$
$$({\mathfrak{s}})$$
λidi. (8)
Minimizing L(λ**) thus yields the values for the Lagrange multipliers and thus** the MaxEnt distribution. In passing we note that it is easy to see that L(λ**) is**
equal to the negative log-likelihood of distribution from Eq. (7) on data x **that**
satisfies fi(x) = di**. Hence, the MaxEnt distribution subject to constraints (3)**
is equivalent to the maximum likelihood distribution of the form (7) fitted to data for which the constraints fi(x) = di **hold deterministically rather than in**
expectation (e.g. Wainwright and Jordan, 2008).

The log-partition function log(Z(λ**)) is well-known to be a convex function,**
such that L(λ**) is convex as well. Thanks to this, it turns out that minimizing**
L(λ**) can be done efficiently for a broad class of constraints, using standard techniques for convex optimization (see Sec. 3.4) or using special purpose techniques**
such as Iterative Proportional Fitting (e.g. Wainwright and Jordan, 2008).

A full discussion of the efficiency of the optimization of the Lagrange multipliers in the most general form of the problem is beyond the scope of **this paper.**
Let us just point out that many results from the graphical models literature can be borrowed to establish tractability results. Rather than staying **at the general**
level, we choose to fully explore a specific type of data and prior information of particular interest to data mining in Sec. 3 below.

## 2.2 Using The Maxent Model To Define Subjective Interestingness Measures

Given a representation of prior information in the form the MaxEnt distribution, subjective interestingness of a pattern can be quantified by contrasting it with the MaxEnt distribution. This can be done by computing some measure of unexpectedness of the pattern e.g. using hypothesis testing, or **by relying on** information theory. Here is a non-exhaustive list of possibilities:
1. Self-information. **A first option for quantifying interestingness of a pattern**
relies on the probability of the pattern under MaxEnt model. The smaller this probability is, the more surprising the pattern when contrasted with