
## 3 Maxent Distributions For Rectangular Databases

In the rest of the paper, we will elaborate on the details of the outlined general approach for specific types of data, prior information, and patterns. In the current Section, we will apply the general MaxEnt modeling strategy to the important case of rectangular databases. To this end, we will cast **the prior** information in the general form of Eq. (1). We will investigate the specific form of the resulting MaxEnt model, and show how it can be fitted in a remarkably efficient way.

## 3.1 Notation

In the rest of this paper, we will denote the database using the matrix D **with**
m rows and n **columns. To maintain generality, we will assume that all matrix**
values belong to some specified set D ⊆ R
+, i.e. D(i, j) ∈ D**. Later we will**
choose the set D to be the set {0, 1} **(to model binary databases), the set of**
positive integers (to model integer-valued databases), or the set of positive reals
(to model real-valued databases). Other choices can be made, and it is fairly straightforward to adapt the derivations accordingly. For notational simplicity, in the subsequent derivations we will assume that D **is discrete and countable.**
However, if D **is continuous the derivations can be adapted easily.**

## 3.2 Swap Randomizations And Prior Information For Databases

For binary databases, it has been argued that row and column sums can often be assumed as prior information.2 **Any pattern that can be explained by** referring to row or column sums in a binary database is then deemed uninformative. Previous work has introduced ways to assess data mining results based on this assumption (Gionis et al, 2007; Mannila, 2008; Hanhijarvi et al, 2009). These methods rely on the ability to sample random databases from the uniform distribution over all databases that satisfy the prior information. **To assess a** frequent itemset in the given database, they then compute the empirical p-value as a subjective interestingness measure, defined as the fraction **of the random**
databases in which the itemset is at least as frequent as in the given database.

Unfortunately, sampling from this uniform distribution cannot be done in a direct way. To overcome this, the authors randomize the given database by iteratively applying elementary randomization operations: so-called swap randomizations that transform any 2 × 2 submatrix of the form 1 0 0 1 **into**
0 1 1 0 **. (See Fig. 1 for a graphical illustration.) Clearly, such operations**
leave the row and column sums invariant. Furthermore, Gionis et al (2007) showed how the limit distribution of a Markov chain of random swap operations is equal to the uniform distribution over all databases with the specified row and 2We refer to Gionis et al (2007) for a detailed argumentation, and to the experiments in Sec. 7.3 of this paper for a particular use case