We refer the reader to [9] for more details about the program. As an example of the advantage of using sets, let us give here the rule dealing with transitivity of explanations (cf 3b §**2.2),** ecinit **referring to explanations not using transitivity**
rule. (\#insert(Set1,E2,Set) means: Set = Set1 ∪ {E2}):
ecSet(I,J,{I}) :- ecinit(I,J,I). ecSet(I,J,{I,E}) :- ecinit(I,J,E), not ecSet(I,J,{I}).

ecSet(I,J,Set) :- ecSet(I,K,Set1), not ecSet(I,J,Set1), ecinit(K,J,E2), E2 != K,
\#insert(Set1,E2,Set).

ecSet(I,J,Set) :- ecSet(I,K,Set), ecinit(K,J,K).

## 3.3 Optimizing The Explanation Atoms

The "weak simplification" rule 3c' §**2.2) is used at this step, omitted here for lack**
of space. Moreover, if two sets of condition Φ, Ψ exist for some **α explains β**,
and if Φ |**= Ψ and not conversely, then only** α explains β bec poss **Ψ is kept,**
the stronger set Φ being discarded. This avoids clearly unnecessary explanation atoms. This part (not logically necessary) is costly, but helps interpreting the result by a human reader.

## 3.4 Checking The Set Of Conditions

Finally, the following program starts from the result of any of the last two preceding programs and checks, in each answer set, whether the set **of conditions is**
satisfied or not. The result is given by explVer(I,J,Set): I explains J bec poss Set where Set **is satisfiable in the answer set considered ("**Ver**" stands for "verified").**
explSuppr(I,J,Set) :- ecSetRes(I,J,Set), -true(E), \#member(E,Set). explVer(I,J,Set) :- ecSetRes(I,J,Set), not explSuppr(I,J,Set). Only "individual" checking is made here, in accordance with the requirement that the computational properties remain manageable.

With the whole chain (§**3.2, 3.3, and 3.4), modifying a rule of the formalism**
can be done easily. The gain of using DLV-Complex instead of pure DLV (or gringo/claspD) is significant and worth mentioning.

## 3.5 Conclusion And Future Work

We have shown how the recent versions of running ASP systems allow **easy**
translation of logical formalisms. The example of the explanation formalism shows that such a translation can already be useful for testing new theories. In a near future, cases from the "real world" should be manageable and the end user should be able to use ASP for a great variety of diagnostic problems.

Here are two considerations about what could be hoped for future **ASP systems in order to deal easily with this kind of problem. Since ASP systems are**
regularly evolving, we can hope that a near future the annoying trick consisting in launching the programs one after the other, and not in a single launch, should become unnecessary. It seems easy to detect that some predicates can safely be computed first, before launching the subsequent computation. In our example, computing ecSet **first, then** ecSetRes **and finally** ecSetVer **is possible, and such**