Based on this observation, we decided to measure the performance of the learned classifiers not in terms of the usual machine learning performance measures, but in terms of misclassification penalty [29]. The misclassification penalty is the additional CPU time we require to solve a problem instance when choosing to solve it with a solver that is not the fastest one. If the selected solver was not able to solve the problem, we assumed the timeout of 3600 seconds minus the CPU time the fastest solver took to be the misclassification penalty. This only gives the lower bound, but the correct value cannot be estimated easily.

We furthermore decided to assign the maximum misclassification penalty (or the maximum possible gain), cf. Figure 1 as a cost to each instance as follows. To bias the WEKA classifiers towards the instances we care about most, we used the common technique of duplicating instances [28]. Each instance appeared in the new data set 1 + dlog2
(cost)e times. The particular formula to determine how often each instance occurs was chosen empirically such that instances with a low cost are not disregarded completely, but instances with a high cost are much more important. Each instance will be in the data set used for training the machine learning classifiers at least once and at most 13 times for a theoretic maximum cost of 3600.

To achieve multi-level classification, each individual classifier below consists of a combination of classifiers. First we make the decision whether to use the alldifferent version equivalent to the binary decomposition or the other one, then, based on the previous decision, we decide which specific version of the alldifferent constraint to use.

Table 1 shows the total misclassification penalty for all classifiers with and without instance duplication on the first data set. It clearly shows that our cost model improves the performance significantly in terms of misclassification penalty for almost all classifiers.

| misclass. penalty [s]   |           |            |                       |
|-------------------------|-----------|------------|-----------------------|
| classifier              | all equal | cost model |                       |
| BayesNet                | 1494      | 3.9        |                       |
| BFTree                  | 8.4       | 1.1        |                       |
| ConjunctiveRule         | 2300      | 1433       |                       |
| DecisionTable           | 249       | 1.6        |                       |
| FT                      | 248       | 1.2        |                       |
| HyperPipes              | 867       | 867        |                       |
| IBk                     | 109       | 109        |                       |
| J48                     | 8.2       | 1.2        |                       |
| J48graft                | 8.2       | 1.2        |                       |
| JRip                    | 283       | 1.3        | misclass. penalty [s] |
| classifier              | all equal | cost model |                       |
| LADTree                 | 8.4       | 6.5        |                       |
| MultilayerPerceptron    | 249       | 8.5        |                       |
| NBTree                  | 9         | 1.3        |                       |
| OneR                    | 69.5      | 409        |                       |
| PART                    | 5.9       | 1          |                       |
| RandomForest            | 41.9      | 0.9        |                       |
| RandomTree              | 1         | 1          |                       |
| REPTree                 | 1099      | 10.8       |                       |
| ZeroR                   | 2304      | 2304       |                       |

Table 1. Misclassification penalty for all classifiers with and without instances duplicated according to their cost in the training data set. All numbers are rounded.