# Distributed Solving Through Model Splitting

Lars Kotthof f and Neil C.A. Moore
{larsko,ncam}@cs.st-andrews.ac.uk University of St Andrews Abstract. Constraint problems can be trivially solved in parallel by exploring different branches of the search tree concurrently. Previous approaches have focused on implementing this functionality in the solver, more or less transparently to the user. We propose a new approach, which modifies the constraint model of the problem. An existing model is split into new models with added constraints that partition the search space. Optionally, additional constraints are imposed that rule out the search already done. The advantages of our approach are that it can be implemented easily, computations can be stopped and restarted, moved to different machines and indeed solved on machines which are not able to communicate with each other at all.

## 1 Introduction

Constraint problems are typically solved by searching through the possible assignments of values to variables. After each such assignment, propagation can rule out possible future assignments based on past assignments and the constraints. This process builds a search tree that explores the space of possible
(partial) solutions to the constraint problem.

There are two different ways to build up these search trees –n-way branching and 2-way branching. This refers to the number of new branches which are explored after each node. Inn-way branching, all then possible assignments to the next variable are branched on. In 2-way branching, there are two branches.

The left branch is of the formx=y wherex is a variable andy is a value from its domain. The right branch is of the formx6=y.

The more commonly used way is 2-way branching, implemented for example in the Minion constraint solver [5]
1. However, regardless of the way the branching is done, exploring the branches can be done concurrently. No information between the branches needs to be exchanged in order to find a solution to the problem.

We exploit this fact by, given the model of a constraint problem, generating new models which partition the remaining search space. These models can then be solved independently. We furthermore represent the state of the search by adding additional constraints such that the splitting of the model can occur at any point during search. The new models can be resumed, taking advantage of both the splitting of the search space and the search already performed. 1 http://minion.sf.net