for which Minion is run before splitting the problem - in the beginning, we set it to a small value to quickly get many models that we can solve in parallel. Then we gradually increase the allotted time as the resource utilisation improves.

Our technique is intended to be used for very large problems which take a long time (many hours, days or weeks) to solve. It is unlikely to be efficient for problems that can be solved in minutes, but on the other hand there is no need for distributed solving if the problem can be solved sequentially in a short amount of time. Only large search spaces can be split in a way that many workers are kept busy without a high communication overhead.

## 5 Detailed Example

We will now have a detailed look at how our approach works for a specific problem. Consider the 4-queens problem. We want to place 4 queens on a 4 × 4 chessboard such that no queen is attacking another queen. Queens can move along rows, columns and diagonals. The constraints therefore have to forbid that two or more queens are in the same row, the same column or on the same diagonal. The constraint model in Figure 2 captures this problem.

language Dominion 0.1 letting n = 4 dim queens[n]: int find queens[..]: int {1..n}
such that alldifferent alldiff(queens[..])
diagonals1 [ not(eq1 eq(queens[i], add(queens[j], j-i))) | i in {0..n-2}, j in {i+1..n-1} ]
diagonals2 [ not(eq2 eq(queens[i], add(queens[j], i-j))) | i in {0..n-2}, j in {i+1..n-1} ]
Fig. 2. Model for the 4-queens problem in the Dominion language [4]. The model describes the n-queens problem in general and is specialised for 4-queens in the second line.

We assume variable ordering queens0, queens1, queens2*, queens*3, ascending value ordering from 1 to 4 and n-way branching. The search tree for a simple backtracking algorithm is depicted in Figure 3. Even for a very small problem like this, there is significant potential for distributed solving.

We now start solving the problem until we reach the assignment *queens*0 = 2.

Then we stop. The constraint we need to add to resume the search at the same point is resume not(innerresume eq(queens[0], 1))