# Learning Multi-Modal Similarity

Brian McFee BMCFEE@CS.UCSD.EDU
Department of Computer Science and Engineering University of California San Diego, CA 92093-0404, USA
Gert Lanckriet GERT@ECE.UCSD.EDU
Department of Electrical and Computer Engineering University of California San Diego, CA 92093-0407, USA

## Editor: Abstract

In many applications involving multi-media data, the definition of similarity between items is integral to several key tasks, *e.g.*, nearest-neighbor retrieval, classification, and recommendation. Data in such regimes typically exhibits multiple modalities, such as acoustic and visual content of video. Integrating such heterogeneous data to form a holistic similarity space is therefore a key challenge to be overcome in many real-world applications.

We present a novel multiple kernel learning technique for integrating heterogeneous data into a single, unified similarity space. Our algorithm learns an optimal ensemble of kernel transformations which conform to measurements of human perceptual similarity, as expressed by relative comparisons. To cope with the ubiquitous problems of subjectivity and inconsistency in multimedia similarity, we develop graph-based techniques to filter similarity measurements, resulting in a simplified and robust training procedure.

## 1. Introduction

In applications such as content-based recommendation systems, the definition of a proper similarity measure between items is crucial to many tasks, including nearest-neighbor retrieval and classification. In some cases, a natural notion of similarity may emerge from domain knowledge, *e.g.*, cosine similarity for bag-of-words models of text. However, in more complex, multi-media domains, there is often no obvious choice of similarity measure. Rather, viewing different aspects of the data may lead to several different, and apparently equally valid notions of similarity. For example, if the corpus consists of musical data, each song or artist may be represented simultaneously by acoustic features (such as rhythm and timbre), semantic features (tags, lyrics), or social features (collaborative filtering, artist reviews and biographies, etc). Although domain knowledge may be employed to imbue each representation with an intrinsic geometry - and, therefore, a sense of similarity —
the different notions of similarity may not be mutually consistent. In such cases, there is generally no obvious way to combine representations to form a unified similarity space which optimally integrates heterogeneous data.

Without extra information to guide the construction of a similarity measure, the situation seems hopeless. However, if some side-information is available, *e.g.*, as provided by human labelers, it can be used to formulate a learning algorithm to optimize the similarity measure. 

arXiv:1008.5163v1 [cs.AI] 30 Aug 2010