the resulting embedding may be degraded. To combat this phenomenon, it is common to learn a scheme for weighting the kernels in a way which is optimal for a particular task. The most common approach to combining the base kernels is to take a positive-weighted sum

$$\sum_{p=1}^{m}\mu_{p}K^{p}\qquad\qquad(\mu_{p}\geq0),$$

where the weights µp are learned in conjunction with a predictor (Lanckriet et al., 2004; Sonnenburg et al.,
2006; Bach, 2008; Cortes et al., 2009). Equivalently, this can be viewed as learning a feature map

$$\phi(x_{i})=\left(\sqrt{\mu_{p}}\phi^{p}(x_{i})\right)_{p=1}^{m},$$

where each base feature map has been scaled by the corresponding weight √µp.

Applying this reasoning to learning an embedding that conforms to perceptual similarity, one might consider a two-stage approach to parameterizing the embedding (Figure 3(a)): first construct a weighted kernel combination, and then project from the combined kernel space. Lin et al. (2009)
formulate a dimensionality reduction algorithm in this way. In the present setting, this would be achieved by simultaneously optimizing W and µp to choose an inner product matrix A from the set

$$\mathcal{K}_{2}=\left\{\left(\sum_{p=1}^{m}\mu_{p}K^{p}\right)W\left(\sum_{p=1}^{m}\mu_{p}K^{p}\right)\ :\ W\succeq0,\forall p,\ \mu_{p}\geq0\right\}$$ $$=\left\{\sum_{p,q=1}^{m}\mu_{p}K^{p}W\mu_{q}K^{q}\ :\ W\succeq0,\forall p,\ \mu_{p}\geq0\right\}.\tag{10}$$

The corresponding distance constraints, however, contain differences of terms cubic in the optimization variables W and µp:

$$\sum_{p,q}\left(K_{i}^{p}-K_{j}^{p}\right)^{\mathsf{T}}\mu_{p}W\mu_{q}\left(K_{i}^{q}-K_{j}^{q}\right)+1\leq\sum_{p,q}\left(K_{k}^{p}-K_{\ell}^{p}\right)^{\mathsf{T}}\mu_{p}W\mu_{q}\left(K_{k}^{q}-K_{\ell}^{q}\right),$$

and are therefore non-convex and difficult to optimize. Even simplifying the class by removing cross-terms, *i.e.*, restricting A to the form

$${\cal K}_{3}=\left\{\sum_{p=1}^{m}\mu_{p}^{2}K^{p}WK^{p}\ :\ W\succeq0,\forall p,\ \mu_{p}\geq0\right\},\tag{11}$$

still leads to a non-convex problem, due to the difference of positive quadratic terms introduced by distance calculations:

$$\sum_{p=1}^{m}\left(K_{i}^{p}-K_{j}^{p}\right)^{\mathsf{T}}\mu_{p}^{2}W\left(\mu_{p}K_{i}^{p}-K_{j}^{p}\right)+1\leq\sum_{p=1}^{m}\left(K_{k}^{p}-K_{\ell}^{p}\right)^{\mathsf{T}}\mu_{p}^{2}W\left(\mu_{p}K_{k}^{p}-K_{\ell}^{p}\right).$$

However, a more subtle problem with this formulation lies in the assumption that a single weight can characterize the contribution of a kernel to the optimal embedding. In general, different kernels may be more or less informative on different subsets of X or different regions of the corresponding feature space. Constraining the embedding to a single metric W with a single weight µp for each kernel may be too restrictive to take advantage of this phenomenon.