
## 4.3 Concatenated Projection

We now return to the original intuition behind Equation 9. The sum-kernel represents the inner product between points in the space formed by concatenating the base feature maps φ p. The sets K2 and K3 characterize projections of the weighted combination space, and turn out to not be amenable to efficient optimization (Figure 3(a)). This can be seen as a consequence of prematurely combining kernels prior to projection.

Rather than projecting the (weighted) concatenation of φ p(·), we could alternatively concatenate learned projections Mp(φ p(·)), as illustrated by Figure 3(b). Intuitively, by defining the embedding as the concatenation of m different projections, we allow the algorithm to learn an ensemble of projections, each tailored to its corresponding domain space and jointly optimized to produce an optimal space. By contrast, the previously discussed formulations apply essentially the same projection to each (weighted) feature space, and are thus much less flexible than our proposed approach.

Mathematically, an embedding function of this form can be expressed as the concatenation

$$g(x)=\left(M^{p}\left(\phi^{p}(x)\right)\right)_{p=1}^{m},$$

Now, given this characterization of the embedding function, we can adapt Algorithm 3 to optimize over multiple kernels. As in the single-kernel case, we introduce regularization terms for each projection operator Mp

$$\sum_{p=1}^{m}\|M^{p}\|_{\mathrm{HS}}^{2}$$

to the objective function. Again, by invoking the representer theorem for each Mp, it follows that

$$M^{p}=N^{p}\left(\Phi^{p}\right)^{\mathsf{T}}$$
,
for some matrix Np, which allows to reformulate the embedding problem as a joint optimization over Np, p = 1**, . . . , m** rather than Mp, p = 1**, . . . , m**. Indeed, the regularization terms can be expressed as

$$\sum_{p=1}^{m}\|M^{p}\|_{\mathrm{HS}}^{2}=\mathrm{tr}((N^{p})^{\mathsf{T}}(N^{p})K^{p}).$$
p)Kp). (12)
The embedding function can now be rewritten as

$$g(x)=\left(M^{p}\left(\phi^{p}(x)\right)\right)_{p=1}^{m}=(N^{p}K_{x}^{p})_{p=1}^{m}\,,$$

and the inner products between embedded points take the form:

$$A_{i j}=\langle g(x_{i}),g(x_{j})\rangle=\sum_{p=1}^{m}\left(N^{p}K_{i}^{p}\right)^{\mathsf{T}}\left(N^{p}K_{j}^{p}\right)$$ $$=\sum_{p=1}^{m}(K_{i}^{p})^{\mathsf{T}}(N^{p})^{\mathsf{T}}(N^{p})(K_{j}^{p}).$$
$$(12)$$

Similarly, squared Euclidean distance also decomposes by kernel:

$$\|g(x_{i})-g(x_{j})\|^{2}=\sum_{p=1}^{m}\left(K_{i}^{p}-K_{j}^{p}\right)^{\mathsf{T}}(N^{p})^{\mathsf{T}}(N^{p})\left(K_{i}^{p}-K_{j}^{p}\right).\tag{13}$$

14