
| Kernel class        | Learned kernel matrix   |               |         |             |
|---------------------|-------------------------|---------------|---------|-------------|
| nP p,q KpW Kq o     |  K1 + K2 + · · · + Km  [W]                         |               |         |             |
| K1 =                |  K1 + K2 + · · · + Km                          |               |         |             |
|                    | K1                      |              |         |             |
| K2                  |                         |               |         |             |
|                 | . . .                   |               |         |             |
| Km                  | T                      |               |         |             |
|                 | µ 2 1W                  | µ1µ2W         | · · ·   | µ1µmW . . . |
| µ2µ1W               | µ2 2W                   | · · ·         |         |             |
| . . .               | . . .                   |               |         |             |
| µmµ1W               | µ2 mW                   |        | K1      |            |
| K2                  |                         |               |         |             |
|                 | . . .                   |               |         |             |
| Km                  |                         |               |         |             |
|                |                         |               |         |             |
| nP p,q µpµqKpW Kq o |                         |               |         |             |
| K2 =                |                     |               |         |             |
| T                  |                         |               |         |             |
|                 |                        |               |         |             |
| µ 2 1W              | 0                       | · · ·         | 0 . . . |             |
|                | 0                       | µ 2 2W        | · · ·   |             |
| . . .               | . . .                   |               |         |             |
| 0                   | µ 2 mW                  |               |         |             |
|                    | K1                      |              |         |             |
| K2                  |                         |               |         |             |
|                 | . . .                   |               |         |             |
| Km                  |                        |               |         |             |
|                | K1                      |              |         |             |
| K2                  |                         |               |         |             |
|                 | . . .                   |               |         |             |
| Km                  |                         |               |         |             |
| nP p µ 2 pKpW Kp o  |                         |               |         |             |
| K3 =                |                     |               |         |             |
| T                  |                         |               |         |             |
|                 |                        |               |         |             |
| W1                  | 0                       | · · ·         | 0 . . . |             |
|                | 0                       | W2            | · · ·   |             |
| . . .               | . . .                   |               |         |             |
| 0                   | Wm                      |               |         |             |
|                    | K1                      |              |         |             |
| K2                  |                         |               |         |             |
|                 | . . .                   |               |         |             |
| Km                  |                        |               |         |             |
|                | K1                      |              |         |             |
| K2                  |                         |               |         |             |
|                 | . . .                   |               |         |             |
| Km                  |                         |               |         |             |
| nP p KpWpKp o       |                         |               |         |             |
| K4 =                |                     |               |         |             |

Table 1: Block-matrix formulations of metric learning for multiple-kernel formulations (K1–K4).

Each Wpis taken to be positive semi-definite. Note that all sets are equal when there is only one base kernel.
Finally, since the matrices Np, p = 1**, . . . , m** only appear in the form of inner products in
(12) and (13), we may instead optimize over PSD matrices Wp = (Np)
T(Np). This renders the regularization terms (12) and distances (13) linear in the optimization variables Wp. Extending Algorithm 3 to this parameterization of g(·) therefore results in an SDP, which is listed as Algorithm 4.

To solve the SDP, we implemented a gradient descent solver, which is described in Appendix B.

The class of kernels over which Algorithm 4 optimizes can be expressed algebraically as

$${\cal K}_{4}=\left\{\sum_{p=1}^{m}K^{p}W^{p}K^{p}\ :\ \forall p,\ W^{p}\succeq0\right\}.\tag{14}$$

Note that K4 contains K3 as a special case when all Wpare positive scalar multiples of each-other.

However, K4 leads to a convex optimization problem, where K3 does not.

Table 1 lists the block-matrix formulations of each of the kernel combination rules described in this section. It is worth noting that it is certainly valid to first form the unweighted combination kernel Kb and then use K1 (Algorithm 3) to learn an optimal projection of the product space. However, as we will demonstrate in Section 5, our proposed multiple-kernel formulation (K4) outperforms the simple unweighted combination rule in practice.