
## 5.2.1 Features

We construct five base kernels over the data, incorporating acoustic, semantic, and social views of the artists.

- **MFCC**: for each artist, we collected between 1 and 10 songs (mean 4). For each song, we extracted a short clip consisting of 10000 half-overlapping 23ms windows. For each window, we computed the first 13 Mel Frequency Cepstral Coefficients (MFCCs) (Davis and Mermelstein, 1990), as well as their first and second instantaneous derivatives. This results in a sequence of 39-dimensional vectors (delta-MFCCs) for each song. Each artist i was then summarized by a Gaussian mixture model (GMM) pi over delta-MFCCs extracted from the corresponding songs. Each GMM has 8 components and diagonal covariance matrices. Finally, the kernel between artists i and j is the probability product kernel (Jebara et al., 2004) between their corresponding delta-MFCC distributions pi, pj :

$$K_{i j}^{\mathrm{mfcc}}=\int{\sqrt{p_{i}(x)p_{j}(x)}}\,d x.$$

- **Auto-tags**: Using the MFCC features described above, we applied the automatic tagging algorithm of Turnbull et al. (2008), which for each song yields a multinomial distribution over a set T of 149 musically-relevant tag words (*auto-tags*). Artist-level tag distributions qi were formed by averaging model parameters (*i.e.*, tag probabilities) across all of the songs of artist i. The kernel between artists i and j for auto-tags is a radial basis function applied to the χ 2-distance between the multinomial distributions qi and qj :
$$K_{i j}^{\mathrm{at}}=\exp\left(-\sigma\sum_{t\in T}\frac{\left(q_{i}(t)-q_{j}(t)\right)^{2}}{q_{i}(t)+q_{j}(t)}\right)$$
$\sigma=256$... 
.
In these experiments, we fixed σ **= 256**.

- **Social tags**: For each artist, we collected the top 100 most frequently used tag words from Last.fm,2a social music website which allows users to label songs or artists with arbitrary tag words or *social tags*. After stemming and stop-word removal, this results in a vocabulary of 7737 tag words. Each artist is then represented by a bag-of-words vector in R
7737, and processed by TF-IDF. The kernel between artists for social tags is the cosine similarity (linear kernel) between TF-IDF vectors.

- **Biography**: Last.fm also provides textual descriptions of artists in the form of user-contributed biographies. We collected biographies for each artist in the *aset400* data set, and after stemming and stop-word removal, we arrived at a vocabulary of 16753 biography words. As with social tags, the kernel between artists is the cosine similarity between TF-IDF bag-of-words vectors.

- **Collaborative filtering**: Celma (2008) collected collaborative filtering data from Last.fm in the form of a bipartite graph over users and artists, where each user is associated with the artists in her listening history. We filtered this data down to include only the aset400 artists,