
| Kernel                    | Accuracy      |           |       |
|---------------------------|---------------|-----------|-------|
| Native                    | K1 (diagonal) | K1 (full) |       |
| MFCC                      | 0.464         | 0.593     | 0.590 |
| Auto-tags (AT)            | 0.559         | 0.568     | 0.594 |
| Social tags (ST)          | 0.752         | 0.773     | 0.796 |
| Biography (Bio)           | 0.611         | 0.629     | 0.760 |
| Collaborative filter (CF) | 0.704         | 0.655     | 0.776 |

Table 3: aset400 embedding results for each of the base kernels. Accuracy is computed in each kernel's native feature space, as well as the space produced by applying Algorithm 3 (*i.e.*,
optimizing over K1 with a single kernel) with either the diagonal or full-matrix formulation.

| Base kernels         | Accuracy      |          |       |
|----------------------|---------------|----------|-------|
| Native               | K4 (diagonal) | K4(full) |       |
| MFCC + AT            | 0.521         | 0.589    | 0.602 |
| ST + Bio             | 0.760         | 0.786    | 0.811 |
| MFCC + AT + CF       | 0.580         | 0.671    | 0.719 |
| ST + Bio + CF        | 0.777         | 0.782    | 0.806 |
| MFCC + AT + ST + Bio | 0.709         | 0.788    | 0.801 |
| All                  | 0.732         | 0.779    | 0.801 |

Table 4: aset400 embedding results with multiple kernel learning: the learned metrics are optimized over K4 by Algorithm 4. *Native* corresponds to distances calculated according to the unweighted sum of base kernels.
artist-level features, whereas ST provides high-level semantic descriptions which are generally more homogeneous across the songs of an artist, and Bio and CF are directly constructed at the artist level. For comparison purposes, we also trained a metric over all kernels with K1 (Algorithm 3),
and achieve 0.711 (diagonal) and 0.764 (full): significantly worse than the K4 results.

Figure 5 illustrates the weights learned by Algorithm 4 using all five kernels and diagonallyconstrained Wp matrices. Note that the learned metrics are both sparse (many 0 weights) and nonuniform across different kernels. In particular, the (lowest-performing) MFCC kernel is eliminated by the algorithm, and the majority of the weight is assigned to the (highest-performing) social tag
(ST) kernel.

A t-SNE (van der Maaten and Hinton, 2008) visualization of the space produced by MKPOE is illustrated in Figure 6. The embedding captures a great deal of high-level genre structure in low dimensions: for example, the *classic rock* and *metal* genres lie at the opposite end of the space from pop and *hip-hop*.