products:

$$d(x_{i},x_{j})=(K_{i}-K_{j})^{\mathsf{T}}W(K_{i}-K_{j})$$ $$=(e_{i}-e_{j})^{\mathsf{T}}KWW(e_{i}-e_{j})$$ $$=\operatorname{tr}(KWW(e_{i}-e_{j})(e_{i}-e_{j})^{\mathsf{T}})=\operatorname{tr}(WKE_{ij}K)$$ $$=\langle W,KE_{ij}K\rangle_{F}\,,$$  where $E_{ij}=(e_{i}-e_{j})(e_{i}-e_{j})^{\mathsf{T}}$.  A margin constraint $(i,j,k,\ell)$ can now be expressed as:
$$\begin{array}{c}{{d(x_{i},x_{j})+1\leq d(x_{k},x_{\ell})+\xi_{i j k\ell}}}\\ {{\langle W,K E_{i j}K\rangle_{F}+1\leq\langle W,K E_{k\ell}K\rangle_{F}+\xi_{i j k\ell}}}\\ {{\xi_{i j k\ell}\geq1+\langle W,K(E_{i j}-E_{k\ell})K\rangle_{F}\,.}}\end{array}$$
$\Rightarrow$  $\Rightarrow$  . 

The slack variables ξ**ijkℓ** can be eliminated from the program by rewriting the objective in terms of the hinge loss h(·) over the constraints:

$$\operatorname*{min}_{W\geq0}f(W){\mathrm{~where~}}f(W)=\operatorname{tr}(W K)+{\frac{\beta}{|{\mathcal{C}}|}}\sum_{{\mathcal{C}}}h\left(1+\langle W,K(E_{i j}-E_{k\ell})K\rangle_{F}\right).$$

The gradient ∇f has two components: one due to regularization, and one due to the hinge loss.

The gradient due to regularization is simply K. The loss term decomposes linearly, and for each
(i, j, k, ℓ) ∈ C, a subgradient direction can be defined:

$$\frac{\partial}{\partial W}h\left(1+d(x_{i},x_{j})-d(x_{k},x_{\ell})\right)=\begin{cases}0&d(x_{i},x_{j})+1\leq d(x_{k},x_{\ell})\\ K(E_{ij}-E_{k\ell})K&\text{otherwise.}\end{cases}\tag{17}$$

Rather than computing each gradient direction independently, we observe that each violated constraint contributes a matrix of the form K(Eij −Ekℓ)K. By linearity, we can collect all (Eij −Ekℓ)
terms and then pre- and post-multiply by K to obtain a more efficient calculation of ∇f:

$${\frac{\partial}{\partial W}}f=K+K\left(\sum_{(i,j,k,\ell)\in\overline{{{C}}}}E_{i j}-E_{k\ell}\right)K,$$

where C is the set of all currently violated constraints.

After each gradient step W 7→ W −α∇f, the updated W is projected back onto the set of positive semidefinite matrices by computing its spectral decomposition and thresholding the eigenvalues by λi7→ max(0, λi).

To extend this derivation to the multiple-kernel case (Algorithm 4), we can define

$$d(x_{i},x_{j})\doteq\sum_{p=1}^{m}d^{p}(x_{i},x_{j}),$$

and exploit linearity to compute each partial derivative **∂/∂W**pindependently.

For the diagonally-constrained case, it suffices to substitute K(Eij − Ekℓ)K 7→ **diag(**K(Eij − Ekℓ)K)
in Equation 17. After each gradient step in the diagonal case, the PSD constraint on W can be enforced by the projection Wii 7→ max(0, Wii).