The remainder of this paper is structured as follows. In Section 2, we develop a graphical framework for interpreting and manipulating subjective similarity measurements. In Section 3, we derive an embedding algorithm which learns an optimal transformation of a single feature space.

In Section 4, we develop a novel multiple-kernel learning formulation for embedding problems, and derive an algorithm to learn an optimal space from heterogeneous data. Section 5 provides experimental results illustrating the effects of graph-processing on noisy similarity data, and the effectiveness of the multiple-kernel embedding algorithm on a music similarity task with human perception measurements. Finally, we prove hardness of dimensionality reduction in this setting in Section 6, and conclude in Section 7.

## 1.2 Preliminaries

A *(strict) partial order* is a binary relation R over a set Z (R⊆Z
2) which satisfies the following properties:1
- Irreflexivity: (**a, a**) ∈/ R,
- Transitivity: (a, b) ∈ R ∧ (b, c) ∈ R ⇒ (**a, c**) ∈ R, - Anti-symmetry: (a, b) ∈ R ⇒ (**b, a**) ∈/ R.

Every partial order can be equivalently represented as a directed acyclic graph (DAG), where each vertex is an element of Z and an edge is drawn from a to b if (**a, b**) ∈ R. For any partial order, R may refer to either the set of ordered tuples {(**a, b**)} or the graph (DAG) representation of the partial order; the use will be clear from context. Let **diam(**R) denote the length of the longest (finite) source-to-sink path in the graph of R.

For a directed graph G, we denote by G∞ its transitive closure, *i.e.*, G∞ contains an edge (**i, j**)
if and only if there exists a path from i to j in G. Similarly, the *transitive reduction* (denoted Gmin)
is the minimal graph with equivalent transitivity to G, *i.e.*, the graph with the fewest edges such that Gmin∞ = G∞.

Let X = {x1, x2**, . . . , x**n} denote the training set of n items. A *Euclidean embedding* is a function g : X → R
d which maps X into a d-dimensional space equipped with the Euclidean (ℓ2)
metric:

$$\|x-y\|_{2}={\sqrt{(x-y)^{\mathsf{T}}(x-y)}}.$$

For any matrix B, let Bi denote its i column vector. A symmetric matrix A ∈ R
n×n has a spectral decomposition A = V ΛV
T, where Λ = diag(λ1, λ2**, . . . , λ**n) is a diagonal matrix containing the eigenvalues of A, and V contains the eigenvectors of A. We adopt the convention that eigenvalues (and corresponding eigenvectors) are sorted in descending order. A is *positive semidefinite* (PSD), denoted by A  0, if each eigenvalue is non-negative: λi ≥ 0, i = 1**, . . . , n**.

Finally, a PSD matrix A gives rise to the Mahalanobis distance function

$$\|x-y\|_{A}={\sqrt{(x-y)^{\mathsf{T}}A(x-y)}}.$$
q(x − y)