Proof: *Soundness.* To prove the soundness of maxRPC3 we must prove that any value that is deleted by maxRPC3 is not maxRPC. Let ai ∈ D(xi) be a value that is deleted by maxRPC3. It is either removed from D(xi) during the initialization phase (line 15) or in line 8 of Algorithm 1, after *searchPCsup* has returned *false*, or in line 12, after *searchPCsup* has returned *true* and *checkPCwit* has returned *false*.

In the first case, since function *initilization* checks all values in a brute-force manner, it is clear that any deleted value ai either has no AC-support or none of its AC-supports is a PC-support in some variable xj . The non-existence of a PCsupport is determined using function *searchPCwit* whose correctness is discussed below.

In the second case, since *searchPCsup* returns *false*, **LastP C**xi,ai,xj is not valid so a new PC-support in D(xj ) is seeked (lines 9-17). This search starts with the value at max(**LastP C**xi,ai,xj+1, **LastAC**xi,ai,xj
) or at max(**LastP C**xi,ai,xj
+1, **LastAC**xi,ai,xj +1), depending on whether **LastAC**xi,ai,xj is valid or not.

This is correct since any value before **LastP C**xi,ai,xj+1 and any value before LastACxi,ai,xj is definitely not an AC-support for ai (similarly for the other case).

searchPCsup will return false either because no AC-support for ai can be found in D(xj ) (line 10), or because for any AC-support found, *searchPCwit* returned false
(line 13). In the former case there is no PC-support for aiin D(xj ) since there is no AC-support. In the latter case, for any AC-support aj found there must be some third variable xk for which no PC-witness for the pair (ai, aj ) exists. For each third variable xk *searchPCwit* correctly identifies a PC-witness if one of the conditions in line 3 holds. In none holds then *searchPCwit* searches for a PC-witness starting from max(**LastAC**xi,ai,xk
, **LastAC**xj ,aj ,xk
) (line 6). This is correct since LastACxi,ai,xk and **LastAC**xj,aj ,xk are updated with the lexicographically smallest support of ai (resp. aj ) in D(xk) by calling function *seekACsup*, meaning that any value smaller than max(**LastAC**xi,ai,xk
, **LastAC**xj ,aj ,xk
) is incompatible with either ai or aj . Therefore, if *searchPCwit* returns *false* then there is no PC-witness for some third variable xk. Hence, if *searchPCsup* returns *false*, it means no PCsupport for ai can be found in D(xj ) and it is thus correctly deleted.

Now assume that the call to *searchPCsup* returned *true* and ai was removed after *checkPCwit* returned *false*. This means that for some variable xk, constrained with both xi and xj , both the first part (lines 3-11) and the second part (lines 13-24)
of *checkPCwit* failed to set the Boolean witness to *true*. Regarding the first part, the failure means that the pair of values (ai, ak), where ak is the last PC-support of aiin D(xk) found, has no PC-witness in D(xj ). In more detail, the search for a PC-witness correctly starts from max(**LastAC**xi,ai,xj
, **LastAC**xj ,aj ,xj
) in line 9, after both **LastAC** pointers have been updated by *seekACsup*. The condition