The space complexities of the algorithms are determined by the space required for data structures **LastP C** and **LastAC**. Since both require O(ed) space, this is the node space complexity of (l)maxRPC3and (l)maxRPC3rm. (l)maxRPC3 has O(end) branch space complexity because of the extra space required for the incremental update and restoration of the data structures. As (l)maxRPC3rm avoid this, its branch space complexity is O(ed).

## 4 Heuristics For Maxrpc Algorithms

Numerous heuristics for ordering constraint or variable revisions have been proposed and used within AC algorithms [11, 3, 1]. Heuristics such as the ones used by AC algorithms can be also used within a maxRPC algorithm to efficiently select the next variable to be removed from the propagation list (line 5 of Algorithm 1).

In addition to this, maxRPC and lmaxRPC algorithms can benefit from the use of heuristics elsewhere in their execution. Once a variable xj has been removed from the propagation list, heuristics can be applied as follows in either a maxRPC or a lmaxRPC algorithm (we use algorithm (l)maxRPC3 for illustration):

1. After a variable xj is removed from L all neighboring variables xi are revised. lmaxRPC (resp. maxRPC) will detect a failure if the condition of PC-support loss (resp. either PC-support or PC-witness loss) occurs for all values of xi. In such situations, the sooner xiis considered and the failure is detected, the more constraint checks will be saved. Hence, the order in which the neighboring variables of xj are considered can be determined using a fail-first type of heuristic.

2. Once an AC-support aj ∈ D(xj ) has been found for a value ai ∈ D(xi),
searchPCsup tries to establish if it is a PC-support. If there is no PC-witness for the pair (ai, aj ) in some variable xk then aj is not a PC-support. Therefore, we can again use fail-first heuristics to determine the order in which the variables forming a triangle with xi and xj are considered.
The above cases apply to both lmaxRPC and maxRPC algorithms. In addition, a maxRPC algorithm can employ heuristics as follows:
3. For each value ai ∈ D(xi) and each variable xk constrained with both xi and xj , Function 4 checks if the pair (ai, ak) still has a PC-witness in D(xj ). If there is no PC-witness or **LastP C**xi,ai,xk is not valid then a new PC-support in xk is seeked. If none is found then ai will be deleted. Again heuristics can be used to determine the order in which the variables constrained with xi and xj are considered.