We also propose a number of heuristics that can be used to efficiently order the searches for PC supports and witnesses. Interestingly, some of the proposed heuristics not only reduce the number of constraint checks but also the number of visited nodes.

We make a detailed experimental evaluation of new and existing algorithms on various problem classes. This is the first wide experimental study of algorithms for maxRPC and its approximations on benchmark non-random problems. Results show that our methods constantly outperform existing algorithms, often by large margins. When applied during search our best method offers up to one order of magnitude reduction in constraint checks, while cpu times are improved up to four times compared to the best existing algorithm. In addition, these speed-ups enable a search algorithm that applies lmaxRPC to compete with or outperform MAC on many problems.

## 2 Background And Related Work

A *Constraint Satisfaction Problem* (CSP) is defined as a tuple (**X, D, C**) where:
X = {x1**, . . . , x**n} is a set of n variables, D = {D(x1)**, . . . , D**(xn)} is a set of domains, one for each variable, with maximum cardinality d, and C = {c1**, . . . , c**e} is a set of e constraints. Each constraint c is a pair (var(c)**, rel**(c)), where var(c) =
{x1**, . . . , x**m} is an ordered subset of X, and rel(c) is a subset of the *Cartesian* product D(x1) × **. . .** × D(xm) that specifies the allowed combinations of values for the variables in var(c). In the following, a binary constraint c with var(c) = {xi, xj} will be denoted by cij , and D(xi) will denote the current domain of variable xi. Each tuple τ ∈ rel(c) is an ordered list of values (a1**, . . . , a**m)
such that aj ∈ D(xj ),j = 1**, . . . , m**. A tuple τ ∈ rel(ci) is *valid* iff none of the values in the tuple has been removed from the domain of the corresponding variable.

The process which verifies whether a given tuple is allowed by a constraint c is called a *constraint check*. A binary CSP is a CSP where each constraint involves at most two variables. We assume that binary constraint checks are performed in constant time. In a binary CSP, a value ai ∈ D(xi) is *arc consistent* (AC) iff for every constraint cij there exists a value aj ∈ D(xj ) s.t. the pair of values (ai, aj ) satisfies cij . In this case aj is called an *AC-support* of ai. A variable is AC iff all its values are AC. A problem is AC iff there is no empty domain in D and all the variables in X are AC.