
## 2.1 Maxrpc

A value ai ∈ D(xi) is *max restricted path consistent* (maxRPC) iff it is AC and for each constraint cij there exists a value aj ∈ D(xj ) that is an AC-support of ai s.t. the pair of values (ai, aj ) is *path consistent* (PC) [5]. A pair of values (ai, aj )
is PC iff for any third variable xk there exists a value ak ∈ D(xk) s.t. ak is an AC-support of both ai and aj . In this case aj is a *PC-support* of aiin xj and ak is a *PC-witness* for the pair (ai, aj ) in xk. A variable is maxRPC iff all its values are maxRPC. A problem is maxRPC iff there is no empty domain and all variables are maxRPC.

To our knowledge, three algorithms for achieving maxRPC have been proposed in the literature so far. The first one, called maxRPC1, is a fine-grained algorithm based on AC6 and has optimal O(end3) time complexity and O(end) space complexity [5]. The second algorithm, called maxRPC2, is a coarse-grained algorithm having O(end3) time and O(ed) space complexity [7]. Finally, maxRPCrm is a coarse-grained algorithm based on AC3rm [10]. The time and space complexities of maxRPCrm are O(en2d 4) and O(end) but it has some advantages compared to the other two because of its lighter use of data structures. Among the three algorithms maxRPC2 seems to be the most promising for stand-alone use as it has a better time and space complexity than maxRPCrm without requiring heavy data structures or complex implementation as maxRPC1 does. On the other hand, maxRPCrm can be better suited for use during search as it avoids the costly maintainance of data structures.

Central to maxRPC2 is the **LastP C** data structure, as we call it here. For each constraint cij and each value ai ∈ D(xi), **LastP C**xi,ai,xj gives the most recently discovered PC-support of aiin D(xj ). maxRPC2 maintains this data structure incrementally. This means that the data structure is copied when moving forward during search (i.e. after a successfully propagated variable assignment)
and restored when backtracking (after a failed variable assignment). This results in the following behavior: When looking for a PC-support for aiin D(xj ), maxRPC2 first checks if **LastP C**xi,ai,xj is valid. If it is not, it searches for a new PC-support starting from the value immediately after **LastP C**xi,ai,xj in D(xj ). In this way a good time complexity bound is achieved. On the other hand, maxRPCrm uses a data structure similar to **LastP C** to store *residues*, i.e. supports that have been discovered during execution and stored for future use, but does not maintain this structure incrementally1. When looking for a PC-support for aiin D(xj ), if the residue **LastP C**xi,ai,xj is not valid then maxRPCrm searches for a new PC-support from scratch in D(xj ). This results in higher complexity, but crucially does not require costly maintainance of the **LastP C** data structure during search.

1maxRPCrm also uses residues in a different context.