array [V, R] of int: r; % The activities resource requirements array [Idx, 1..3] of int: E; % The precedences of form x + c <= y set of int: Times = 0..t max; % The planning period
%---------------------------------------------------------------------%
% Variables array [V] of var Times: S;
var Times: objective; %---------------------------------------------------------------------% % Constraints
% Precedence constraints constraint forall (id in Idx) (S[E[id, 1]] + E[id, 2] <= S[E[id, 3]]); % Cumulative resource constraints constraint forall (res in R) (cumulative(S, p, [r[i, res] | i in V], rcap[res])); % Objective constraints constraint forall (i in V) (S[i] + p[i] <= objective);
%---------------------------------------------------------------------%
% Search solve minimize objective;
%---------------------------------------------------------------------%
This basic model has a number of weaknesses: first the initial domains of the start times are large, second each precedence constraint is modelled as one individual propagator, and finally the SAT solver in LCG has no structural information about activities in disjunction.

A smaller initial domain can be computed by taking into account the precedences in E as described in the next subsection. Individual propagators for precedences may not be so bad for a small number of precedences, but for a larger number of propagators, their queuing behaviour may result in long and costly sequences of propagation steps.

A global propagator can efficiently adjust the time-bounds in O(n log n + m) time as described in Feydy et al. [13], but we did not have access to such a propagator for the experiments. Reified precedence constraints can be used for modelling activities in disjunctions as described later in this section.

## 3.1. Initial Domain

A smaller initial domain can be obtained for the start time variables by applying the Bellman-Ford single source shortest path algorithm [6, 14] on the digraph G = (V
0, E
0)
where V
0 = V ∪ {v0, vn+1}, E
0 = {(i, j, −dij ) | (i, j, dij ) ∈ E} ∪ {(v0, i, 0),(*i, v*n+1, −pi) | i *∈ V}*, v0 is the source node, and vn+1 is the sink node. The digraph is referred as the activity-on-node network in the literature (e.g. [5, 22]). If the digraph contains a