As branching heuristic the Variable-State-Independent-Decaying-Sum (Vsids) [21] is used which is a part of the SAT solver. In each branch it selects the literal with the highest activity counter where an *activity counter* is assigned to each literal, and is increased during conflict analysis if the literal is related to the conflict. The analysis results in a nogood which is added to the clause data base. Here, we use the 1UIP as a nogood.

In order to accelerate the solution finding and increase the robustness of the search on hard instances Vsids can be combined with restarts which has been shown beneficial in SAT solving. On restart the set of nogoods and the activity counter has changed, so that the search will explore a very different part of the search tree. In the remainder Vsids with restart is denoted by Restart. Different restart policies can be applied, here a geometric restart on nodes with an initial limit of 250 and a restart factor of 2.0 are used.

## 4.3. Hybrid Branching

At the beginning of each search the activity counters are all initialized with the same value which can result in a poor performance of Vsids at the start of search. In order to avoid this situation at first Mslf can be chosen for branching and then Vsids used after a restart is performed (e.g. after a specific number of explored nodes). This has the advantage that the deterministic search initializes the activity counters with more meaningful values that can be fully exploited by Vsids. Here, we switch the searches after exploration of the first 500 nodes unless otherwise stated. In the remainder we refer to the strategy as Hot Start. Once more, the Vsids search after the first restart can benefit from restart. We denote the hybrid branching approach with restarts by Hot Restart.

## 5. Computational Results

We carried out experiments on Rcpsp/max instances available from [2] and accessible from the PSPLib [1]. Our approach is compared to the best known exact and non-exact methods so far on each testset. At the website http://www.cs.mu.oz.au/~pjs/rcpsp detailed results can be obtained.

Our methods are evaluated on the following testsets which were systematically created using the instance generator ProGen/max (Schwindt [28]):
- CD - 1080 instances with 100 activities and 5 resources (cf. Schwindt [30]).

- UBO - ubo10, ubo20, ubo50, ubo100, and ubo200: each containing 90 instances with 5 resources and 10, 20, 50, 100, and 200 activities respectively (cf.

Franck et al. [15]).

- SM - j10, j20, and j30: each containing 270 instances with 5 resources and 10, 20, and 30 activities respectively (cf. Kolisch et al. [18]).