Note that although the testset SM consists of small instances they are considerably harder than e.g. ubo10 and ubo20.

The experiments were run on Intel(R) Xeon(R) CPU E54052 processor with 2 GHz clock running GNU/Linux. The code was written in Mercury using the G12 Constraint Programming Platform and compiled with the Mercury Compiler using grade hlc.gc.trseg. Each run was given a 10 minute runtime limit.

## 5.1. Setup And Table Notations

In order to solve each instance a two-phase process was used. Both phases used the basic model with the two extensions described in Subsections 3.1 and 3.2.

In the first phase a Hot Start search was run to determine a first solution or to prove the infeasibility of the instance. In contrast to the normal Hot Start we give the deterministic search more time to find a first solution and therefore we switch to Vsids only after after 5 × n nodes are explored, where n is the number of activities.

P
The feasibility runs were set up with the trivial upper bound on the makespan tmax =
i∈V max(pi, max{dij | (i, j, dij ) *∈ E}*). The first phase was run until a solution (with makespan UB) was found or infeasibility proved or the time limit reached. In the first phase the the search strategy used should be at both finding feasible solutions and proving infeasibility. Hence, it could be exchanged with methods which might be more suitable than Hot Start.

In the second optimization phase, each feasible instance was set up again this time with tmax = UB. The tighter bound is highly beneficial to lazy clause generation since it reduces the number of Boolean variables required to represent the problem. The search for optimality was performed using one of the various search strategies defined in the previous section.

The execution of the two-phased process lead to the following measurements.

rtmax: The runtime limit in seconds (for both phases together).

rtavg: The average runtime in seconds (for both phases).

fails: The average number of fails perfomed in both phases of the search.

feas: The percentage of instances for which a solution was found. infeas: The percentage of instances for which the infeasibility was proven. opt: The percentage of instances for which an optimal solution was found and proven.

∆LB: The average distance from the best known lower bounds of feasible instances given in [2].

\#svd: The number of instances which were proven to be infeasible or optimal. cmpr(i): Columns with this header give measurements only related to those instances that were solved by each procedure where i is the number of these instances.