
## 6. Conclusion

In this paper we minimize the project duration of Rcpsp/max using a generic constraint programming solver that includes nogood learning facilities and conflict-driven search. Experiments on three well-established benchmark suites show that our solver is able to find better solutions quicker than competing approaches, and prove optimality for many more instances than competing approaches.

We use a two-phase process. In the first phase a solution is generated or infeasibility is proven and in the second phase a branch-and-bound algorithm is used for optimization where the problem is set up with an upper bound on the project duration found from the first solution. In contrast to some previous approaches we use individual propagators for precedence constraints instead of propagators taking all precedences into account at once. This yields not only to weaker propagation, but also slower detection of infeasibility, in particular for instances with a large number of precedences like for instances with 100 activities or more from the testset UBO. Hence our generic search used in the first phase is sometimes slower in finding a first solution than other problem-specific approaches in the literature. However, the first-phase generic search could be replaced by one of these methods.

Overall, our method could close 573 open problems and improve a further 51 upper bounds on the project duration from the 58 remaining open problems, according to the best known results given in [2]. We note though that the methods from Ballest´ın et al. [4], and Oddi and Rasconi [23] may have found better upper bounds than are recorded in [2] on some problems, but we could not find any record of this. Note that our method is highly robust: our method proves the best known optimal for each already closed instance in every testset. Furthermore, for every open instance in every testset we either close the instance or improve the upper bounds, except for 7 instances (and here we regenerate the best known upper bound for 4 of them). Acknowledgements. National ICT Australia is funded by the Australian Government as represented by the Department of Broadband, Communications and the Digital Economy and the Australian Research Council.

## References

[1] PSPLib - project scheduling problem library, May 2009.

http://129.187.106.231/psplib/.

[2] Project Duration Problem RCPSP/max, Aug 2010. http://www.wior.unikarlsruhe.de/LS Neumann/Forschung/ProGenMax/rcpspmax.html.

[3] Aggoun, A., and Beldiceanu, N. Extending CHIP in order to solve complex scheduling and placement problems. *Mathematical and Computer Modelling 17*, 7 (Dec. 1993), 57–73.