of variables V, a domain D which determine the finite set of possible values of each variable in V. A *domain* D is a complete mapping from V to finite sets of integers. Hence given domain D, then D(x) is the set of possible values that variable x can take. Let minD(x) = min(D(x)) and maxD(x) = max(D(x)). Let [ *l .. u* ] = {d | l ≤ d ≤ *u, d* ∈ Z}
denote a *range* of integers., where [ *l .. u* ] = ∅ if *l > u*. In this paper we will concentrate on domains where D(x) is a range for all x ∈ V. The *initial domain* is referred as D*init*. Let D1 and D2 be domains, then D1 is *stronger* than D2, written D1 v D2, if D1(v) ⊆ D2(v)
for all v ∈ V. Similarly if D1 v D2 then D2 is *weaker* than D1. For instance, all domains D that occur will be stronger than the initial domain, i.e. D v D*init*.

A *valuation* θ is a mapping of variables to values, written {x1 7→ d1*, . . . , x*n 7→ dn}.

We extend the valuation θ to map expressions or constraints involving the variables in the natural way. Let *vars* be the function that returns the set of variables appearing in an expression, constraint or valuation. In an abuse of notation, we define a valuation θ to be an element of a domain D, written θ ∈ D, if θ(v) ∈ D(v) for all v ∈ *vars*(θ). Define a *valuation domain* D as one where |D(v)| = 1, ∀v ∈ V. We can define the corresponding valuation θD for a valuation domain D as {v 7→ d | D(v) = {d}, v *∈ V}*.

Then a constraint c ∈ C is a set of valuations over *vars*(c) which give the allowable values for a set of variables. In FD solvers constraints are implemented by propagators. A *propagator* f implementing c is a monotonically decreasing function on domains such that for all domains D v D*init*: f(D) v D and no solutions are lost, i.e. {θ ∈ D | θ ∈ c} = {θ ∈ f(D) | θ ∈ c}. We assume each propagator f is *checking*, that is if D is a valuation domain then f(D) = D iff θD restricted to *vars*(c) is a solution of c.

Given a set of constraints C we assume a corresponding set of propagators F = {f | c ∈
C, f implements c}.

A *propagation solver* for a set of propagators F and current domain D, solv(*F, D*),
repeatedly applies all the propagators in F starting from domain D until there is no further change in resulting domain. solv(*F, D*) is the weakest domain D0 v D which is a fixpoint (i.e. f(D0) = D0) for all f ∈ F.

Finite domain solving interleaves propagation with search decisions. Given a initial problem (C,D) where F are the propagators for the constraints C we first run the propagation solver D0 = solv(*F, D*). If this determines failure then the problem has no solution and we backtrack to visit the next unexplored choice. If D is a valuation domain we have determined a solution. Otherwise we pick a variable x ∈ V and split its domain D0(x)
into two disjoint parts S1 ∪S2 = D0(x) creating two subproblems (C, D1), (C, D2), where Di(x) = Si and Di(v) = D0(v), v 6= x, whose solutions are the solutions of the original problem. We then recursively explore the first problem, and when we have shown it has no solutions we explore the second problem.

As defined above finite domain propagation is only applicable to *satisfaction problems*. Finite domain solvers solve optimization problems by mapping them to repeated satisfaction problems. Given an objective function o to minimize under constraints C
with domain D, the finite domain solving approach first finds a solution θ to (C, D), and then finds a solution to (C ∪ {o ≤ θ(o)}, D), that is, the satisfaction problem of finding a better solution than previously founds. It repeats this process until a problem is reached with no solution, in which case the last found solution is optimal. If the process is halted