before proving optimality, then the solving process just returns the last solution found as the best known.

Finite domain propagation is a powerful generic approach to solving combinatorial optimization problems. Its chief strengths are the ability to model problems at a very high level, and the use of global propagators, specialized propagation algorithms for important constraints.

## 2.1.1. Cumulative

Of particular interest to us in this work is the global cumulative constraint for cumulative resource scheduling.

The cumulative constraint introduced by Aggoun and Beldiceanu [3] in 1993 is a constraint with Zinc [20] type predicate cumulative(list of var int: s, list of int: d, list of int: r, int: c);
Each of the first three arguments are lists of the same length n and indicate information about a set of *activities*. s[i] is the *variable start time* of the i th activity, d[i] is the fixed duration of the i th activity, and r[i] is the fixed *resource usage* (per time unit) of the i th activity. The last argument c is the fixed *resource capacity*.

The cumulative constraints represent cumulative resources with a constant capacity over the considered planning horizon applied to non-preemptive activities, *i.e.* if they are started they cannot be interrupted. Without loss of generality we assume that all values are integral and non-negative and there is a planning horizon tmax which is the latest time any activity can finish. Example 2. Consider the five activities [*a, b, c, d, e*] from Example 1 with durations
[2, 5, 3, 1, 2] and resource requirements [3, 2, 1, 2, 2] and a resource capacity of 4. This is represented by the cumulative constraint.

cumulative([sa, sb, sc, sd, se], [2, 5, 3, 1, 2], [3, 2, 1, 2, 2].4)
Imagine each task must start at time 0 or after and finish before time 8. The cumulative problem corresponds to packing the rectangles shown in Figure 2(a) into the resource box shown below. ✷
There are many propagation algorithms for cumulative, but the most widely used is based on timetable propagation [19]. An activity i has a *compulsory part* given domain D
from [maxD s[i].. minD s[i]+d[i]−1], that requires that activity i makes us of r[i] resources at each of the times in [ maxD s[i] .. minD s[i] + d[i] − 1 ] if the range is non-empty. The timetable propagator for cumulative first determines the *resource usage* profile ru[t]
which sums for each time t the resources requires for all compulsory parts of activities at that time. If at some time t the profile exceeds the resource capacity, i.e. ru[t] > c, the constraint is violated and failure detected. If at some time t point the resource used in the profile that there is not enough left for an activity i, i.e. ru[t] + r[i] > c,