
## 2.3. Lazy Clause Generation

Lazy clause generation is a hybrid of finite domain propagation and Boolean satisfiability. The key idea in lazy clause generation is to run a finite domain propagation solver, but to build explanation of the propagations made by the solver by recording them as clauses on a Boolean variable representation of the problem. Hence as the FD search progresses we lazily create a clausal representation of the problem. The hybrid has the advantages of FD solving, but inherits the SAT solvers ability to create nogoods to drastically reduce search, and use activity based search.

## 2.3.1. Variable Representation

In lazy clause generation each integer variable x ∈ V with the initial domain D*init* =
[ *l .. u* ] is represented by the following Boolean variables Jx = lK*, . . . ,* Jx = uK and Jx ≤
lK*, . . . ,* Jx ≤ u − 1K. The variable Jx = dK is true if x takes the value d, and false if x takes a value different from d. Similarly the variable Jx ≤ dK is true if x takes a value less than or equal to d and false for a value greater than d. Note that we use Jx = dK
and Jx ≤ dK throughout the paper as the *names* of Boolean variables. Sometimes the notation Jd ≤ xK is used for the literal ¬Jx ≤ d − 1K.

Not every assignment of Boolean variables is consistent with the integer variable x, for example {Jx = 3K, Jx ≤ 2K} (i.e. both Boolean variables are true) requires that x is both 3 and ≤ 2. In order to ensure that assignments represent a consistent set of possibilities for the integer variable x we add to the SAT solver the clauses DOM (x)
that encode Jx ≤ dK → Jx ≤ d + 1K, l ≤ *d < u*, Jx = lK ↔ Jx ≤ lK, Jx = dK ↔ (Jx ≤
dK ∧ ¬Jx ≤ d − 1K)*, l < d < u*, and Jx = uK ↔ ¬Jx ≤ u − 1K where D*init*(x) = [ *l .. u* ]. We let DOM = ∪{DOM (v) | v *∈ V}*.

Any assignment A on these Boolean variables can be converted to a domain: *domain*(A)(x) =
{d ∈ Dinit(x) | ∀JcK ∈ *A, vars*(JcK) = {x} : x = d |= c}, that is, the domain includes all values for x that are consistent with all the Boolean variables related to x. It should be noted that the domain may assign no values to some variable.

Example 4. Consider Example 1 and assume D*init*(si) = [ 0 .. 15 ] for i ∈ {*a, b, c, d, e*}.

The assignmentA = {¬Jsa ≤ 1K, ¬Jsa = 3K, ¬Jsa = 4K, Jsa ≤ 6K, ¬Jsb ≤ 2K, Jsb ≤
5K, ¬Jsc ≤ 4K, Jsc ≤ 7K, ¬Jse ≤ 3K} is consistent with sa = 2, sa = 5, and sa = 6.

Hence *domain*(A)(sa) = {2, 5, 6}. For the remaining variables *domain*(A)(sb) = [ 3 .. 5 ],
domain(A)(sc) = [ 5 .. 7 ], *domain*(A)(sd) = [ 0 .. 15 ], and *domain*(A)(se) = [ 4 .. 15 ].

Note that for brevity A is not a fixpoint of a SAT propagator for DOM(sa) since we are missing many implied literals such as ¬Jsa = 0K, ¬Jsa = 8K, ¬Jsa ≤ 0K etc. ✷

## 2.3.2. Explaining Propagators

In LCG a propagator is extended from a mapping from domains to domains to a generator of clauses describing propagation. When f(D) 6= D we assume the propagator f can determine a clause C to explain each domain change. Similarly when f(D) is a false domain the propagator must create a clause C that explains the failure.