In order to obtain a global view and to evaluate the statistical significance of our experimental results, a set of paired t-tests were performed. In these tests we compared the CPU performance of the 2-way branching scheme **against all**
the other branching schemes, over all the instances used in the experiments. We measured the mean difference, standard deviation, t-value and the 95% confidence interval. The risk level (called alpha level) was set to 0.05. Results are collected in Table 4.

As the results show, d-way branching and domain splitting are clearly **inefficient compared to 2-way branching. The mean CPU reduction in the all**
set branching techniques is always greater than zero with 2-way clustering set branching being slightly better. However, the negative values at the confidence interval indicate that this reduction was not observed in all the tried instances.

Although 2-way ties and clustering set branching achieve equivalent **mean CPU** reduction, the t-values score show that the spread (or variability) of the scores for 2-way clustering set branching is significantly higher compared to 2-way ties set branching. The t-value scores lead us to conclude that 2-way clustering set branching is a promising branching technique, since in our experiments it has displayed the best overall performance.

Finally, we have to mention that the number of clusters produced by **xmeans during search was usually quite low (2-3). In some cases, typically for**
small domain sizes, there was only one cluster generated because all values had similar score. In such a case our method switched to either d-way or **2-way** branching depending on the style of set branching employed.

## 5 Conclusions

We performed an experimental evaluation of branching methods for CSPs including the commonly used 2-way and d**-way schemes as well as other less widely**
used ones. We also proposed and evaluated a generic set branching **method that** partitions domains into sets of values by using information provided by the value ordering heuristic as input to a clustering algorithm. Results showed that set branching methods, including our approach, are competitive and often better compared to standard 2-way branching. We now plan to investigate ways to achieve more efficient domain partitions by automatically tuning the parameters of the clustering algorithm. Also, it would be interesting to study clustering of domains using information from multiple value ordering heuristics.

## References
