In 2-way branching, after a variable x with domain {a1, . . . , ad} **is chosen, its**
values are assigned through a sequence of binary choices [14]. The first choice point creates two branches, corresponding to the assignment of a1 to x **(left**
branch) and the removal of a1 from the domain of x **(right branch). An alternative branching scheme which was extensively used in the past, and is still used**
by some solvers, is d-way branching. In this case, after variable x **is selected,**
d branches are built, each one corresponding to one of the d possible value assignments of x**. 2-way branching was described by Freuder and Sabin within the**
MAC algorithm [14] and in theory it can achieve exponential savings in search effort compared to d**-way branching [8]. However, the few experimental studies** comparing 2-way and d**-way branching have not displayed significant differences**
between the two [11, 16]. Very recently Balafoutis and Stergiou showed that depending on the variable ordering heuristic used there can be from marginal to exponential differences between the two schemes [1].

Another technique that is sometimes used is dichotomic domain splitting
[4]. This method originates from numerical CSPs and proceeds by splitting the current domain of the selected variable into two sets, usually based **on the lexicographical ordering of the values. In this way branching is performed on the**
two created sets and the branching factor is reduced to two. Although domain splitting drastically reduces the branching factor, it can result in a much deeper search tree since the effects of propagation after a branching decision may be diminished.

In addition to these standard schemes, techniques that group together the values of the selected variable, and branch on these created groups instead of individual values, have been proposed [7, 10, 15, 2, 17, 9]. The criteria used for the grouping of values and the methods used to perform the grouping can be different, but all these techniques aim at reducing the size of the search tree. In this paper, following [9], we call any such method a set branching **method.**
Our first goal in this paper is to experimentally study the effect of different branching schemes for finite domain CSPs on search performance. Although some existing branching methods have been compared to one another (e.g. [16]),
to our knowledge this is the first systematic evaluation of several existing alternatives. In addition, we propose and study a generic set branching method where the partition of a domain into sets is created using the scores **assigned**
to values by a value ordering heuristic, and a clustering algorithm. Before employing such a method, two fundamental questions need to be adressed: What is the measure of similarity between values, and how do we partition domains using such a measure? Most of the approaches to set branching that have been proposed in the past have either used very strict measures of similarity or are problem specific. Our method offers a generic solution to both the problem of similarity evaluation and the partitioning of domains. For the former we exploit the information acquired from the value ordering heuristic, while for **the latter** we use a clustering algorithm from machine learning.

Experimental results from a wide range of benchmarks demonstrate that exponential differences between branching schemes, as predicted in theory between