splitting tends to achieve weaker propagation compared to d**-way and 2-way**
branching. So, although it drastically reduces the branching factor, it can result in a much deeper search tree. Domain splitting is mostly used on optimization problems and especially when the domains of the variables are very large. An example of a search tree explored with domain splitting is shown in Figure 1c.

## 3.1 Set Branching

Very recently, Kitching and Bacchus explored the applicability of **set branching** for constraint optimization problems [9]. The basic idea is to group together values that offer similar improvement to the currently computed bounds. In this way entire groups of values that offer no improvement to the bounds can be refuted, resulting in smaller tree sizes.

In this paper we use the term set branching **to refer to any branching technique that, using some similarity criterion, identifies values that can be grouped**
together and branched on as a set. Dichotomic domain splitting and 2-way branching can be seen as manifestations of this generic method that use simple grouping criteria. Domain splitting creates two sets of values based **on their lexicographical ordering. 2-way branching splits the domain into two sets where the**
first includes a single value and the second the rest of the values. In **general, in** order to define a set branching technique, two questions need to be addressed:
What is the measure of similarity between values, and how are **domains partitioned using such a measure**?

The idea of set branching for CSPs has been explored in the past. Freuder introduced the notion of interchangeability, substitutability, and their weaker, but tractable, neighborhood versions as means to identify values with similar behavior [5]. Two values of a variable are neighborhhood interchangeable iff they have exactly the same supports in all constraints. One value a **is neighborhood** substitutable for another value b if the set of values inconsistent wth a **is a subset** of the values inconsistent with b**. These notions were exploited, for example in** [7, 2, 13], to group together values when branching and in this way perform set branching. The drawback of these techniques is that their conditions are too strong, as in many problems neighborhood interchangeable and substitutable values are very rare.

Larrosa investigated the merging of similar subproblems during search using forward checking [10]. According to this approach, values whose assignment leads to similar subproblems are grouped together and branched on as a set. Experiments performed on crossword puzzle generation problems displayed promising results. However, the measure of subproblem similarity and the algorithm used to partition the domains according to this measure are both problem **specific.**
Silaghi et al. proposed a method for partitioning the domains of variables based on the Cartesian product representation of the search space [15]. This method is particularly suitable for finding all solutions but it requires an explicit extensional representation of the constraints in the problem.

A generic and simple approach to set branching that can be applied on a wide range of problems was proposed by van Hoeve and Milano [17]. In this